/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.grounding.model.DetailsErrorResponse;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ApiError {
    @JsonProperty(value="code")
    private String code;
    @JsonProperty(value="message")
    private String message;
    @JsonProperty(value="requestId")
    private String requestId;
    @JsonProperty(value="target")
    private String target;
    @JsonProperty(value="details")
    private List<DetailsErrorResponse> details = new ArrayList<DetailsErrorResponse>();
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected ApiError() {
    }

    @Nonnull
    public ApiError code(@Nonnull String code) {
        this.code = code;
        return this;
    }

    @Nonnull
    public String getCode() {
        return this.code;
    }

    public void setCode(@Nonnull String code) {
        this.code = code;
    }

    @Nonnull
    public ApiError message(@Nonnull String message) {
        this.message = message;
        return this;
    }

    @Nonnull
    public String getMessage() {
        return this.message;
    }

    public void setMessage(@Nonnull String message) {
        this.message = message;
    }

    @Nonnull
    public ApiError requestId(@Nullable String requestId) {
        this.requestId = requestId;
        return this;
    }

    @Nonnull
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(@Nullable String requestId) {
        this.requestId = requestId;
    }

    @Nonnull
    public ApiError target(@Nullable String target) {
        this.target = target;
        return this;
    }

    @Nonnull
    public String getTarget() {
        return this.target;
    }

    public void setTarget(@Nullable String target) {
        this.target = target;
    }

    @Nonnull
    public ApiError details(@Nullable List<DetailsErrorResponse> details) {
        this.details = details;
        return this;
    }

    @Nonnull
    public ApiError addDetailsItem(@Nonnull DetailsErrorResponse detailsItem) {
        if (this.details == null) {
            this.details = new ArrayList<DetailsErrorResponse>();
        }
        this.details.add(detailsItem);
        return this;
    }

    @Nonnull
    public List<DetailsErrorResponse> getDetails() {
        return this.details;
    }

    public void setDetails(@Nullable List<DetailsErrorResponse> details) {
        this.details = details;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("ApiError has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.code != null) {
            declaredFields.put("code", this.code);
        }
        if (this.message != null) {
            declaredFields.put("message", this.message);
        }
        if (this.requestId != null) {
            declaredFields.put("requestId", this.requestId);
        }
        if (this.target != null) {
            declaredFields.put("target", this.target);
        }
        if (this.details != null) {
            declaredFields.put("details", this.details);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiError apiError = (ApiError)o;
        return Objects.equals(this.cloudSdkCustomFields, apiError.cloudSdkCustomFields) && Objects.equals(this.code, apiError.code) && Objects.equals(this.message, apiError.message) && Objects.equals(this.requestId, apiError.requestId) && Objects.equals(this.target, apiError.target) && Objects.equals(this.details, apiError.details);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.message, this.requestId, this.target, this.details, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiError {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    message: ").append(this.toIndentedString(this.message)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("    target: ").append(this.toIndentedString(this.target)).append("\n");
        sb.append("    details: ").append(this.toIndentedString(this.details)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return code -> message -> new ApiError().code(code).message(message);
    }

    public static interface Builder {
        public Builder1 code(@Nonnull String var1);
    }

    public static interface Builder1 {
        public ApiError message(@Nonnull String var1);
    }
}

