/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.grounding.model.MetaData;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BasePipelineResponse {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="metadata")
    private MetaData metadata;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected BasePipelineResponse() {
    }

    @Nonnull
    public BasePipelineResponse id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(@Nonnull String id) {
        this.id = id;
    }

    @Nonnull
    public BasePipelineResponse type(@Nonnull String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    public String getType() {
        return this.type;
    }

    public void setType(@Nonnull String type) {
        this.type = type;
    }

    @Nonnull
    public BasePipelineResponse metadata(@Nullable MetaData metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nonnull
    public MetaData getMetadata() {
        return this.metadata;
    }

    public void setMetadata(@Nullable MetaData metadata) {
        this.metadata = metadata;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("BasePipelineResponse has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.id != null) {
            declaredFields.put("id", this.id);
        }
        if (this.type != null) {
            declaredFields.put("type", this.type);
        }
        if (this.metadata != null) {
            declaredFields.put("metadata", this.metadata);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasePipelineResponse basePipelineResponse = (BasePipelineResponse)o;
        return Objects.equals(this.cloudSdkCustomFields, basePipelineResponse.cloudSdkCustomFields) && Objects.equals(this.id, basePipelineResponse.id) && Objects.equals(this.type, basePipelineResponse.type) && Objects.equals(this.metadata, basePipelineResponse.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.type, this.metadata, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BasePipelineResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return id -> type -> new BasePipelineResponse().id(id).type(type);
    }

    public static interface Builder {
        public Builder1 id(@Nonnull String var1);
    }

    public static interface Builder1 {
        public BasePipelineResponse type(@Nonnull String var1);
    }
}

