/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.grounding.model.EmbeddingConfig;
import com.sap.ai.sdk.grounding.model.VectorKeyValueListPair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class Collection {
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="embeddingConfig")
    private EmbeddingConfig embeddingConfig;
    @JsonProperty(value="metadata")
    private List<VectorKeyValueListPair> metadata = new ArrayList<VectorKeyValueListPair>();
    @JsonProperty(value="id")
    private UUID id;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected Collection() {
    }

    @Nonnull
    public Collection title(@Nullable String title) {
        this.title = title;
        return this;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    @Nonnull
    public Collection embeddingConfig(@Nonnull EmbeddingConfig embeddingConfig) {
        this.embeddingConfig = embeddingConfig;
        return this;
    }

    @Nonnull
    public EmbeddingConfig getEmbeddingConfig() {
        return this.embeddingConfig;
    }

    public void setEmbeddingConfig(@Nonnull EmbeddingConfig embeddingConfig) {
        this.embeddingConfig = embeddingConfig;
    }

    @Nonnull
    public Collection metadata(@Nullable List<VectorKeyValueListPair> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nonnull
    public Collection addMetadataItem(@Nonnull VectorKeyValueListPair metadataItem) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<VectorKeyValueListPair>();
        }
        this.metadata.add(metadataItem);
        return this;
    }

    @Nonnull
    public List<VectorKeyValueListPair> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(@Nullable List<VectorKeyValueListPair> metadata) {
        this.metadata = metadata;
    }

    @Nonnull
    public Collection id(@Nonnull UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public UUID getId() {
        return this.id;
    }

    public void setId(@Nonnull UUID id) {
        this.id = id;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("Collection has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.title != null) {
            declaredFields.put("title", this.title);
        }
        if (this.embeddingConfig != null) {
            declaredFields.put("embeddingConfig", this.embeddingConfig);
        }
        if (this.metadata != null) {
            declaredFields.put("metadata", this.metadata);
        }
        if (this.id != null) {
            declaredFields.put("id", this.id);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Collection collection = (Collection)o;
        return Objects.equals(this.cloudSdkCustomFields, collection.cloudSdkCustomFields) && Objects.equals(this.title, collection.title) && Objects.equals(this.embeddingConfig, collection.embeddingConfig) && Objects.equals(this.metadata, collection.metadata) && Objects.equals(this.id, collection.id);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.embeddingConfig, this.metadata, this.id, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Collection {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    embeddingConfig: ").append(this.toIndentedString(this.embeddingConfig)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return embeddingConfig -> id -> new Collection().embeddingConfig(embeddingConfig).id(id);
    }

    public static interface Builder {
        public Builder1 embeddingConfig(@Nonnull EmbeddingConfig var1);
    }

    public static interface Builder1 {
        public Collection id(@Nonnull UUID var1);
    }
}

