/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.grounding.model.EmbeddingConfig;
import com.sap.ai.sdk.grounding.model.VectorKeyValueListPair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CollectionRequest {
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="embeddingConfig")
    private EmbeddingConfig embeddingConfig;
    @JsonProperty(value="metadata")
    private List<VectorKeyValueListPair> metadata = new ArrayList<VectorKeyValueListPair>();
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected CollectionRequest() {
    }

    @Nonnull
    public CollectionRequest title(@Nullable String title) {
        this.title = title;
        return this;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    @Nonnull
    public CollectionRequest embeddingConfig(@Nonnull EmbeddingConfig embeddingConfig) {
        this.embeddingConfig = embeddingConfig;
        return this;
    }

    @Nonnull
    public EmbeddingConfig getEmbeddingConfig() {
        return this.embeddingConfig;
    }

    public void setEmbeddingConfig(@Nonnull EmbeddingConfig embeddingConfig) {
        this.embeddingConfig = embeddingConfig;
    }

    @Nonnull
    public CollectionRequest metadata(@Nullable List<VectorKeyValueListPair> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nonnull
    public CollectionRequest addMetadataItem(@Nonnull VectorKeyValueListPair metadataItem) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<VectorKeyValueListPair>();
        }
        this.metadata.add(metadataItem);
        return this;
    }

    @Nonnull
    public List<VectorKeyValueListPair> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(@Nullable List<VectorKeyValueListPair> metadata) {
        this.metadata = metadata;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("CollectionRequest has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.title != null) {
            declaredFields.put("title", this.title);
        }
        if (this.embeddingConfig != null) {
            declaredFields.put("embeddingConfig", this.embeddingConfig);
        }
        if (this.metadata != null) {
            declaredFields.put("metadata", this.metadata);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CollectionRequest collectionRequest = (CollectionRequest)o;
        return Objects.equals(this.cloudSdkCustomFields, collectionRequest.cloudSdkCustomFields) && Objects.equals(this.title, collectionRequest.title) && Objects.equals(this.embeddingConfig, collectionRequest.embeddingConfig) && Objects.equals(this.metadata, collectionRequest.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.embeddingConfig, this.metadata, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CollectionRequest {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    embeddingConfig: ").append(this.toIndentedString(this.embeddingConfig)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return embeddingConfig -> new CollectionRequest().embeddingConfig(embeddingConfig);
    }

    public static interface Builder {
        public CollectionRequest embeddingConfig(@Nonnull EmbeddingConfig var1);
    }
}

