/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.grounding.model.DataRepositoryType;
import com.sap.ai.sdk.grounding.model.RetrievalKeyValueListPair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DataRepository {
    @JsonProperty(value="id")
    private UUID id;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="metadata")
    private List<RetrievalKeyValueListPair> metadata = new ArrayList<RetrievalKeyValueListPair>();
    @JsonProperty(value="type")
    private DataRepositoryType type;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected DataRepository() {
    }

    @Nonnull
    public DataRepository id(@Nonnull UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public UUID getId() {
        return this.id;
    }

    public void setId(@Nonnull UUID id) {
        this.id = id;
    }

    @Nonnull
    public DataRepository title(@Nonnull String title) {
        this.title = title;
        return this;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    public void setTitle(@Nonnull String title) {
        this.title = title;
    }

    @Nonnull
    public DataRepository metadata(@Nullable List<RetrievalKeyValueListPair> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nonnull
    public DataRepository addMetadataItem(@Nonnull RetrievalKeyValueListPair metadataItem) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<RetrievalKeyValueListPair>();
        }
        this.metadata.add(metadataItem);
        return this;
    }

    @Nonnull
    public List<RetrievalKeyValueListPair> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(@Nullable List<RetrievalKeyValueListPair> metadata) {
        this.metadata = metadata;
    }

    @Nonnull
    public DataRepository type(@Nullable DataRepositoryType type) {
        this.type = type;
        return this;
    }

    @Nullable
    public DataRepositoryType getType() {
        return this.type;
    }

    public void setType(@Nullable DataRepositoryType type) {
        this.type = type;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("DataRepository has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.id != null) {
            declaredFields.put("id", this.id);
        }
        if (this.title != null) {
            declaredFields.put("title", this.title);
        }
        if (this.metadata != null) {
            declaredFields.put("metadata", this.metadata);
        }
        if (this.type != null) {
            declaredFields.put("type", (Object)this.type);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataRepository dataRepository = (DataRepository)o;
        return Objects.equals(this.cloudSdkCustomFields, dataRepository.cloudSdkCustomFields) && Objects.equals(this.id, dataRepository.id) && Objects.equals(this.title, dataRepository.title) && Objects.equals(this.metadata, dataRepository.metadata) && Objects.equals((Object)this.type, (Object)dataRepository.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.title, this.metadata, this.type, this.cloudSdkCustomFields});
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DataRepository {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return id -> title -> type -> new DataRepository().id(id).title(title).type(type);
    }

    public static interface Builder {
        public Builder1 id(@Nonnull UUID var1);
    }

    public static interface Builder1 {
        public Builder2 title(@Nonnull String var1);
    }

    public static interface Builder2 {
        public DataRepository type(@Nullable DataRepositoryType var1);
    }
}

