/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.grounding.model.BaseDocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DocumentCreateRequest {
    @JsonProperty(value="documents")
    private List<BaseDocument> documents = new ArrayList<BaseDocument>();
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected DocumentCreateRequest() {
    }

    @Nonnull
    public DocumentCreateRequest documents(@Nonnull List<BaseDocument> documents) {
        this.documents = documents;
        return this;
    }

    @Nonnull
    public DocumentCreateRequest addDocumentsItem(@Nonnull BaseDocument documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<BaseDocument>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    @Nonnull
    public List<BaseDocument> getDocuments() {
        return this.documents;
    }

    public void setDocuments(@Nonnull List<BaseDocument> documents) {
        this.documents = documents;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("DocumentCreateRequest has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.documents != null) {
            declaredFields.put("documents", this.documents);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentCreateRequest documentCreateRequest = (DocumentCreateRequest)o;
        return Objects.equals(this.cloudSdkCustomFields, documentCreateRequest.cloudSdkCustomFields) && Objects.equals(this.documents, documentCreateRequest.documents);
    }

    public int hashCode() {
        return Objects.hash(this.documents, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentCreateRequest {\n");
        sb.append("    documents: ").append(this.toIndentedString(this.documents)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return documents -> new DocumentCreateRequest().documents(documents);
    }

    public static interface Builder {
        public DocumentCreateRequest documents(@Nonnull List<BaseDocument> var1);

        default public DocumentCreateRequest documents(BaseDocument ... documents) {
            return this.documents(Arrays.asList(documents));
        }
    }
}

