/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DocumentKeyValueListPair {
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="value")
    private List<String> value = new ArrayList<String>();
    @JsonProperty(value="matchMode")
    private MatchModeEnum matchMode;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected DocumentKeyValueListPair() {
    }

    @Nonnull
    public DocumentKeyValueListPair key(@Nonnull String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    public void setKey(@Nonnull String key) {
        this.key = key;
    }

    @Nonnull
    public DocumentKeyValueListPair value(@Nonnull List<String> value) {
        this.value = value;
        return this;
    }

    @Nonnull
    public DocumentKeyValueListPair addValueItem(@Nonnull String valueItem) {
        if (this.value == null) {
            this.value = new ArrayList<String>();
        }
        this.value.add(valueItem);
        return this;
    }

    @Nonnull
    public List<String> getValue() {
        return this.value;
    }

    public void setValue(@Nonnull List<String> value) {
        this.value = value;
    }

    @Nonnull
    public DocumentKeyValueListPair matchMode(@Nullable MatchModeEnum matchMode) {
        this.matchMode = matchMode;
        return this;
    }

    @Nullable
    public MatchModeEnum getMatchMode() {
        return this.matchMode;
    }

    public void setMatchMode(@Nullable MatchModeEnum matchMode) {
        this.matchMode = matchMode;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("DocumentKeyValueListPair has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.key != null) {
            declaredFields.put("key", this.key);
        }
        if (this.value != null) {
            declaredFields.put("value", this.value);
        }
        if (this.matchMode != null) {
            declaredFields.put("matchMode", (Object)this.matchMode);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentKeyValueListPair documentKeyValueListPair = (DocumentKeyValueListPair)o;
        return Objects.equals(this.cloudSdkCustomFields, documentKeyValueListPair.cloudSdkCustomFields) && Objects.equals(this.key, documentKeyValueListPair.key) && Objects.equals(this.value, documentKeyValueListPair.value) && Objects.equals((Object)this.matchMode, (Object)documentKeyValueListPair.matchMode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.value, this.matchMode, this.cloudSdkCustomFields});
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentKeyValueListPair {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    matchMode: ").append(this.toIndentedString((Object)this.matchMode)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return key -> value -> new DocumentKeyValueListPair().key(key).value(value);
    }

    public static enum MatchModeEnum {
        ANY("ANY"),
        ALL("ALL"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private MatchModeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        @Nonnull
        public String getValue() {
            return this.value;
        }

        @Nonnull
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        @Nullable
        public static MatchModeEnum fromValue(@Nonnull String value) {
            for (MatchModeEnum b : MatchModeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }
    }

    public static interface Builder {
        public Builder1 key(@Nonnull String var1);
    }

    public static interface Builder1 {
        public DocumentKeyValueListPair value(@Nonnull List<String> var1);

        default public DocumentKeyValueListPair value(String ... value) {
            return this.value(Arrays.asList(value));
        }
    }
}

