/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.grounding.model.VectorChunk;
import com.sap.ai.sdk.grounding.model.VectorDocumentKeyValueListPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DocumentOutput {
    @JsonProperty(value="id")
    private UUID id;
    @JsonProperty(value="metadata")
    private List<VectorDocumentKeyValueListPair> metadata = new ArrayList<VectorDocumentKeyValueListPair>();
    @JsonProperty(value="chunks")
    private List<VectorChunk> chunks = new ArrayList<VectorChunk>();
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected DocumentOutput() {
    }

    @Nonnull
    public DocumentOutput id(@Nonnull UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public UUID getId() {
        return this.id;
    }

    public void setId(@Nonnull UUID id) {
        this.id = id;
    }

    @Nonnull
    public DocumentOutput metadata(@Nullable List<VectorDocumentKeyValueListPair> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nonnull
    public DocumentOutput addMetadataItem(@Nonnull VectorDocumentKeyValueListPair metadataItem) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<VectorDocumentKeyValueListPair>();
        }
        this.metadata.add(metadataItem);
        return this;
    }

    @Nonnull
    public List<VectorDocumentKeyValueListPair> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(@Nullable List<VectorDocumentKeyValueListPair> metadata) {
        this.metadata = metadata;
    }

    @Nonnull
    public DocumentOutput chunks(@Nonnull List<VectorChunk> chunks) {
        this.chunks = chunks;
        return this;
    }

    @Nonnull
    public DocumentOutput addChunksItem(@Nonnull VectorChunk chunksItem) {
        if (this.chunks == null) {
            this.chunks = new ArrayList<VectorChunk>();
        }
        this.chunks.add(chunksItem);
        return this;
    }

    @Nonnull
    public List<VectorChunk> getChunks() {
        return this.chunks;
    }

    public void setChunks(@Nonnull List<VectorChunk> chunks) {
        this.chunks = chunks;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("DocumentOutput has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.id != null) {
            declaredFields.put("id", this.id);
        }
        if (this.metadata != null) {
            declaredFields.put("metadata", this.metadata);
        }
        if (this.chunks != null) {
            declaredFields.put("chunks", this.chunks);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentOutput documentOutput = (DocumentOutput)o;
        return Objects.equals(this.cloudSdkCustomFields, documentOutput.cloudSdkCustomFields) && Objects.equals(this.id, documentOutput.id) && Objects.equals(this.metadata, documentOutput.metadata) && Objects.equals(this.chunks, documentOutput.chunks);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.metadata, this.chunks, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentOutput {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    chunks: ").append(this.toIndentedString(this.chunks)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return id -> chunks -> new DocumentOutput().id(id).chunks(chunks);
    }

    public static interface Builder {
        public Builder1 id(@Nonnull UUID var1);
    }

    public static interface Builder1 {
        public DocumentOutput chunks(@Nonnull List<VectorChunk> var1);

        default public DocumentOutput chunks(VectorChunk ... chunks) {
            return this.chunks(Arrays.asList(chunks));
        }
    }
}

