/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.grounding.model.VectorDocumentKeyValueListPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DocumentWithoutChunks {
    @JsonProperty(value="metadata")
    private List<VectorDocumentKeyValueListPair> metadata = new ArrayList<VectorDocumentKeyValueListPair>();
    @JsonProperty(value="id")
    private UUID id;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected DocumentWithoutChunks() {
    }

    @Nonnull
    public DocumentWithoutChunks metadata(@Nonnull List<VectorDocumentKeyValueListPair> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nonnull
    public DocumentWithoutChunks addMetadataItem(@Nonnull VectorDocumentKeyValueListPair metadataItem) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<VectorDocumentKeyValueListPair>();
        }
        this.metadata.add(metadataItem);
        return this;
    }

    @Nonnull
    public List<VectorDocumentKeyValueListPair> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(@Nonnull List<VectorDocumentKeyValueListPair> metadata) {
        this.metadata = metadata;
    }

    @Nonnull
    public DocumentWithoutChunks id(@Nonnull UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public UUID getId() {
        return this.id;
    }

    public void setId(@Nonnull UUID id) {
        this.id = id;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("DocumentWithoutChunks has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.metadata != null) {
            declaredFields.put("metadata", this.metadata);
        }
        if (this.id != null) {
            declaredFields.put("id", this.id);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentWithoutChunks documentWithoutChunks = (DocumentWithoutChunks)o;
        return Objects.equals(this.cloudSdkCustomFields, documentWithoutChunks.cloudSdkCustomFields) && Objects.equals(this.metadata, documentWithoutChunks.metadata) && Objects.equals(this.id, documentWithoutChunks.id);
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.id, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentWithoutChunks {\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return metadata -> id -> new DocumentWithoutChunks().metadata(metadata).id(id);
    }

    public static interface Builder {
        public Builder1 metadata(@Nonnull List<VectorDocumentKeyValueListPair> var1);

        default public Builder1 metadata(VectorDocumentKeyValueListPair ... metadata) {
            return this.metadata(Arrays.asList(metadata));
        }
    }

    public static interface Builder1 {
        public DocumentWithoutChunks id(@Nonnull UUID var1);
    }
}

