/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.grounding.model.DocumentOutput;
import com.sap.ai.sdk.grounding.model.VectorKeyValueListPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DocumentsChunk {
    @JsonProperty(value="id")
    private UUID id;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="metadata")
    private List<VectorKeyValueListPair> metadata = new ArrayList<VectorKeyValueListPair>();
    @JsonProperty(value="documents")
    private List<DocumentOutput> documents = new ArrayList<DocumentOutput>();
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected DocumentsChunk() {
    }

    @Nonnull
    public DocumentsChunk id(@Nonnull UUID id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public UUID getId() {
        return this.id;
    }

    public void setId(@Nonnull UUID id) {
        this.id = id;
    }

    @Nonnull
    public DocumentsChunk title(@Nonnull String title) {
        this.title = title;
        return this;
    }

    @Nonnull
    public String getTitle() {
        return this.title;
    }

    public void setTitle(@Nonnull String title) {
        this.title = title;
    }

    @Nonnull
    public DocumentsChunk metadata(@Nullable List<VectorKeyValueListPair> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nonnull
    public DocumentsChunk addMetadataItem(@Nonnull VectorKeyValueListPair metadataItem) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<VectorKeyValueListPair>();
        }
        this.metadata.add(metadataItem);
        return this;
    }

    @Nonnull
    public List<VectorKeyValueListPair> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(@Nullable List<VectorKeyValueListPair> metadata) {
        this.metadata = metadata;
    }

    @Nonnull
    public DocumentsChunk documents(@Nonnull List<DocumentOutput> documents) {
        this.documents = documents;
        return this;
    }

    @Nonnull
    public DocumentsChunk addDocumentsItem(@Nonnull DocumentOutput documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<DocumentOutput>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    @Nonnull
    public List<DocumentOutput> getDocuments() {
        return this.documents;
    }

    public void setDocuments(@Nonnull List<DocumentOutput> documents) {
        this.documents = documents;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("DocumentsChunk has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.id != null) {
            declaredFields.put("id", this.id);
        }
        if (this.title != null) {
            declaredFields.put("title", this.title);
        }
        if (this.metadata != null) {
            declaredFields.put("metadata", this.metadata);
        }
        if (this.documents != null) {
            declaredFields.put("documents", this.documents);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentsChunk documentsChunk = (DocumentsChunk)o;
        return Objects.equals(this.cloudSdkCustomFields, documentsChunk.cloudSdkCustomFields) && Objects.equals(this.id, documentsChunk.id) && Objects.equals(this.title, documentsChunk.title) && Objects.equals(this.metadata, documentsChunk.metadata) && Objects.equals(this.documents, documentsChunk.documents);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.metadata, this.documents, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentsChunk {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    documents: ").append(this.toIndentedString(this.documents)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return id -> title -> documents -> new DocumentsChunk().id(id).title(title).documents(documents);
    }

    public static interface Builder {
        public Builder1 id(@Nonnull UUID var1);
    }

    public static interface Builder1 {
        public Builder2 title(@Nonnull String var1);
    }

    public static interface Builder2 {
        public DocumentsChunk documents(@Nonnull List<DocumentOutput> var1);

        default public DocumentsChunk documents(DocumentOutput ... documents) {
            return this.documents(Arrays.asList(documents));
        }
    }
}

