/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.grounding.model.ValidationError;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class HTTPValidationError {
    @JsonProperty(value="detail")
    private List<ValidationError> detail = new ArrayList<ValidationError>();
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected HTTPValidationError() {
    }

    @Nonnull
    public HTTPValidationError detail(@Nullable List<ValidationError> detail) {
        this.detail = detail;
        return this;
    }

    @Nonnull
    public HTTPValidationError addDetailItem(@Nonnull ValidationError detailItem) {
        if (this.detail == null) {
            this.detail = new ArrayList<ValidationError>();
        }
        this.detail.add(detailItem);
        return this;
    }

    @Nonnull
    public List<ValidationError> getDetail() {
        return this.detail;
    }

    public void setDetail(@Nullable List<ValidationError> detail) {
        this.detail = detail;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("HTTPValidationError has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.detail != null) {
            declaredFields.put("detail", this.detail);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HTTPValidationError htTPValidationError = (HTTPValidationError)o;
        return Objects.equals(this.cloudSdkCustomFields, htTPValidationError.cloudSdkCustomFields) && Objects.equals(this.detail, htTPValidationError.detail);
    }

    public int hashCode() {
        return Objects.hash(this.detail, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HTTPValidationError {\n");
        sb.append("    detail: ").append(this.toIndentedString(this.detail)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static HTTPValidationError create() {
        return new HTTPValidationError();
    }
}

