/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.grounding.model.SharePointConfig;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MSSharePointConfiguration {
    @JsonProperty(value="destination")
    private String destination;
    @JsonProperty(value="sharePoint")
    private SharePointConfig sharePoint;
    @JsonProperty(value="cronExpression")
    private String cronExpression;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected MSSharePointConfiguration() {
    }

    @Nonnull
    public MSSharePointConfiguration destination(@Nonnull String destination) {
        this.destination = destination;
        return this;
    }

    @Nonnull
    public String getDestination() {
        return this.destination;
    }

    public void setDestination(@Nonnull String destination) {
        this.destination = destination;
    }

    @Nonnull
    public MSSharePointConfiguration sharePoint(@Nonnull SharePointConfig sharePoint) {
        this.sharePoint = sharePoint;
        return this;
    }

    @Nonnull
    public SharePointConfig getSharePoint() {
        return this.sharePoint;
    }

    public void setSharePoint(@Nonnull SharePointConfig sharePoint) {
        this.sharePoint = sharePoint;
    }

    @Nonnull
    public MSSharePointConfiguration cronExpression(@Nullable String cronExpression) {
        this.cronExpression = cronExpression;
        return this;
    }

    @Nonnull
    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(@Nullable String cronExpression) {
        this.cronExpression = cronExpression;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("MSSharePointConfiguration has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.destination != null) {
            declaredFields.put("destination", this.destination);
        }
        if (this.sharePoint != null) {
            declaredFields.put("sharePoint", this.sharePoint);
        }
        if (this.cronExpression != null) {
            declaredFields.put("cronExpression", this.cronExpression);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MSSharePointConfiguration msSharePointConfiguration = (MSSharePointConfiguration)o;
        return Objects.equals(this.cloudSdkCustomFields, msSharePointConfiguration.cloudSdkCustomFields) && Objects.equals(this.destination, msSharePointConfiguration.destination) && Objects.equals(this.sharePoint, msSharePointConfiguration.sharePoint) && Objects.equals(this.cronExpression, msSharePointConfiguration.cronExpression);
    }

    public int hashCode() {
        return Objects.hash(this.destination, this.sharePoint, this.cronExpression, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MSSharePointConfiguration {\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    sharePoint: ").append(this.toIndentedString(this.sharePoint)).append("\n");
        sb.append("    cronExpression: ").append(this.toIndentedString(this.cronExpression)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return destination -> sharePoint -> new MSSharePointConfiguration().destination(destination).sharePoint(sharePoint);
    }

    public static interface Builder {
        public Builder1 destination(@Nonnull String var1);
    }

    public static interface Builder1 {
        public MSSharePointConfiguration sharePoint(@Nonnull SharePointConfig var1);
    }
}

