/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.sap.ai.sdk.grounding.model.CreatePipeline;
import com.sap.ai.sdk.grounding.model.MSSharePointConfiguration;
import com.sap.ai.sdk.grounding.model.MetaData;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MSSharePointPipelineCreateRequest
implements CreatePipeline {
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonProperty(value="configuration")
    private MSSharePointConfiguration _configuration;
    @JsonProperty(value="metadata")
    private MetaData metadata;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected MSSharePointPipelineCreateRequest() {
    }

    @Nonnull
    public MSSharePointPipelineCreateRequest type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    @Nonnull
    public MSSharePointPipelineCreateRequest _configuration(@Nonnull MSSharePointConfiguration _configuration) {
        this._configuration = _configuration;
        return this;
    }

    @Nonnull
    public MSSharePointConfiguration getConfiguration() {
        return this._configuration;
    }

    public void setConfiguration(@Nonnull MSSharePointConfiguration _configuration) {
        this._configuration = _configuration;
    }

    @Nonnull
    public MSSharePointPipelineCreateRequest metadata(@Nullable MetaData metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nonnull
    public MetaData getMetadata() {
        return this.metadata;
    }

    public void setMetadata(@Nullable MetaData metadata) {
        this.metadata = metadata;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("MSSharePointPipelineCreateRequest has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.type != null) {
            declaredFields.put("type", (Object)this.type);
        }
        if (this._configuration != null) {
            declaredFields.put("_configuration", this._configuration);
        }
        if (this.metadata != null) {
            declaredFields.put("metadata", this.metadata);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MSSharePointPipelineCreateRequest msSharePointPipelineCreateRequest = (MSSharePointPipelineCreateRequest)o;
        return Objects.equals(this.cloudSdkCustomFields, msSharePointPipelineCreateRequest.cloudSdkCustomFields) && Objects.equals((Object)this.type, (Object)msSharePointPipelineCreateRequest.type) && Objects.equals(this._configuration, msSharePointPipelineCreateRequest._configuration) && Objects.equals(this.metadata, msSharePointPipelineCreateRequest.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this._configuration, this.metadata, this.cloudSdkCustomFields});
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MSSharePointPipelineCreateRequest {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    _configuration: ").append(this.toIndentedString(this._configuration)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return type -> _configuration -> new MSSharePointPipelineCreateRequest().type(type)._configuration(_configuration);
    }

    public static enum TypeEnum {
        MS_SHARE_POINT("MSSharePoint"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        @Nonnull
        public String getValue() {
            return this.value;
        }

        @Nonnull
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        @Nonnull
        public static TypeEnum fromValue(@Nonnull String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static interface Builder {
        public Builder1 type(@Nonnull TypeEnum var1);
    }

    public static interface Builder1 {
        public MSSharePointPipelineCreateRequest _configuration(@Nonnull MSSharePointConfiguration var1);
    }
}

