/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RetrievalSearchConfiguration {
    @JsonProperty(value="maxChunkCount")
    private Integer maxChunkCount;
    @JsonProperty(value="maxDocumentCount")
    private Integer maxDocumentCount;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected RetrievalSearchConfiguration() {
    }

    @Nonnull
    public RetrievalSearchConfiguration maxChunkCount(@Nullable Integer maxChunkCount) {
        this.maxChunkCount = maxChunkCount;
        return this;
    }

    @Nullable
    public Integer getMaxChunkCount() {
        return this.maxChunkCount;
    }

    public void setMaxChunkCount(@Nullable Integer maxChunkCount) {
        this.maxChunkCount = maxChunkCount;
    }

    @Nonnull
    public RetrievalSearchConfiguration maxDocumentCount(@Nullable Integer maxDocumentCount) {
        this.maxDocumentCount = maxDocumentCount;
        return this;
    }

    @Nullable
    public Integer getMaxDocumentCount() {
        return this.maxDocumentCount;
    }

    public void setMaxDocumentCount(@Nullable Integer maxDocumentCount) {
        this.maxDocumentCount = maxDocumentCount;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("RetrievalSearchConfiguration has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.maxChunkCount != null) {
            declaredFields.put("maxChunkCount", this.maxChunkCount);
        }
        if (this.maxDocumentCount != null) {
            declaredFields.put("maxDocumentCount", this.maxDocumentCount);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetrievalSearchConfiguration retrievalSearchConfiguration = (RetrievalSearchConfiguration)o;
        return Objects.equals(this.cloudSdkCustomFields, retrievalSearchConfiguration.cloudSdkCustomFields) && Objects.equals(this.maxChunkCount, retrievalSearchConfiguration.maxChunkCount) && Objects.equals(this.maxDocumentCount, retrievalSearchConfiguration.maxDocumentCount);
    }

    public int hashCode() {
        return Objects.hash(this.maxChunkCount, this.maxDocumentCount, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RetrievalSearchConfiguration {\n");
        sb.append("    maxChunkCount: ").append(this.toIndentedString(this.maxChunkCount)).append("\n");
        sb.append("    maxDocumentCount: ").append(this.toIndentedString(this.maxDocumentCount)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static RetrievalSearchConfiguration create() {
        return new RetrievalSearchConfiguration();
    }
}

