/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.grounding.model.DataRepositoryType;
import com.sap.ai.sdk.grounding.model.RetrievalKeyValueListPair;
import com.sap.ai.sdk.grounding.model.RetrievalSearchConfiguration;
import com.sap.ai.sdk.grounding.model.RetrievalSearchDocumentKeyValueListPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RetrievalSearchFilter {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="searchConfiguration")
    private RetrievalSearchConfiguration searchConfiguration;
    @JsonProperty(value="dataRepositories")
    private List<String> dataRepositories = new ArrayList<String>(Arrays.asList("*"));
    @JsonProperty(value="dataRepositoryType")
    private DataRepositoryType dataRepositoryType;
    @JsonProperty(value="dataRepositoryMetadata")
    private List<RetrievalKeyValueListPair> dataRepositoryMetadata = new ArrayList<RetrievalKeyValueListPair>();
    @JsonProperty(value="documentMetadata")
    private List<RetrievalSearchDocumentKeyValueListPair> documentMetadata = new ArrayList<RetrievalSearchDocumentKeyValueListPair>();
    @JsonProperty(value="chunkMetadata")
    private List<RetrievalKeyValueListPair> chunkMetadata = new ArrayList<RetrievalKeyValueListPair>();
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected RetrievalSearchFilter() {
    }

    @Nonnull
    public RetrievalSearchFilter id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(@Nonnull String id) {
        this.id = id;
    }

    @Nonnull
    public RetrievalSearchFilter searchConfiguration(@Nullable RetrievalSearchConfiguration searchConfiguration) {
        this.searchConfiguration = searchConfiguration;
        return this;
    }

    @Nonnull
    public RetrievalSearchConfiguration getSearchConfiguration() {
        return this.searchConfiguration;
    }

    public void setSearchConfiguration(@Nullable RetrievalSearchConfiguration searchConfiguration) {
        this.searchConfiguration = searchConfiguration;
    }

    @Nonnull
    public RetrievalSearchFilter dataRepositories(@Nullable List<String> dataRepositories) {
        this.dataRepositories = dataRepositories;
        return this;
    }

    @Nonnull
    public RetrievalSearchFilter addDataRepositoriesItem(@Nonnull String dataRepositoriesItem) {
        if (this.dataRepositories == null) {
            this.dataRepositories = new ArrayList<String>(Arrays.asList("*"));
        }
        this.dataRepositories.add(dataRepositoriesItem);
        return this;
    }

    @Nonnull
    public List<String> getDataRepositories() {
        return this.dataRepositories;
    }

    public void setDataRepositories(@Nullable List<String> dataRepositories) {
        this.dataRepositories = dataRepositories;
    }

    @Nonnull
    public RetrievalSearchFilter dataRepositoryType(@Nullable DataRepositoryType dataRepositoryType) {
        this.dataRepositoryType = dataRepositoryType;
        return this;
    }

    @Nullable
    public DataRepositoryType getDataRepositoryType() {
        return this.dataRepositoryType;
    }

    public void setDataRepositoryType(@Nullable DataRepositoryType dataRepositoryType) {
        this.dataRepositoryType = dataRepositoryType;
    }

    @Nonnull
    public RetrievalSearchFilter dataRepositoryMetadata(@Nullable List<RetrievalKeyValueListPair> dataRepositoryMetadata) {
        this.dataRepositoryMetadata = dataRepositoryMetadata;
        return this;
    }

    @Nonnull
    public RetrievalSearchFilter addDataRepositoryMetadataItem(@Nonnull RetrievalKeyValueListPair dataRepositoryMetadataItem) {
        if (this.dataRepositoryMetadata == null) {
            this.dataRepositoryMetadata = new ArrayList<RetrievalKeyValueListPair>();
        }
        this.dataRepositoryMetadata.add(dataRepositoryMetadataItem);
        return this;
    }

    @Nonnull
    public List<RetrievalKeyValueListPair> getDataRepositoryMetadata() {
        return this.dataRepositoryMetadata;
    }

    public void setDataRepositoryMetadata(@Nullable List<RetrievalKeyValueListPair> dataRepositoryMetadata) {
        this.dataRepositoryMetadata = dataRepositoryMetadata;
    }

    @Nonnull
    public RetrievalSearchFilter documentMetadata(@Nullable List<RetrievalSearchDocumentKeyValueListPair> documentMetadata) {
        this.documentMetadata = documentMetadata;
        return this;
    }

    @Nonnull
    public RetrievalSearchFilter addDocumentMetadataItem(@Nonnull RetrievalSearchDocumentKeyValueListPair documentMetadataItem) {
        if (this.documentMetadata == null) {
            this.documentMetadata = new ArrayList<RetrievalSearchDocumentKeyValueListPair>();
        }
        this.documentMetadata.add(documentMetadataItem);
        return this;
    }

    @Nonnull
    public List<RetrievalSearchDocumentKeyValueListPair> getDocumentMetadata() {
        return this.documentMetadata;
    }

    public void setDocumentMetadata(@Nullable List<RetrievalSearchDocumentKeyValueListPair> documentMetadata) {
        this.documentMetadata = documentMetadata;
    }

    @Nonnull
    public RetrievalSearchFilter chunkMetadata(@Nullable List<RetrievalKeyValueListPair> chunkMetadata) {
        this.chunkMetadata = chunkMetadata;
        return this;
    }

    @Nonnull
    public RetrievalSearchFilter addChunkMetadataItem(@Nonnull RetrievalKeyValueListPair chunkMetadataItem) {
        if (this.chunkMetadata == null) {
            this.chunkMetadata = new ArrayList<RetrievalKeyValueListPair>();
        }
        this.chunkMetadata.add(chunkMetadataItem);
        return this;
    }

    @Nonnull
    public List<RetrievalKeyValueListPair> getChunkMetadata() {
        return this.chunkMetadata;
    }

    public void setChunkMetadata(@Nullable List<RetrievalKeyValueListPair> chunkMetadata) {
        this.chunkMetadata = chunkMetadata;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("RetrievalSearchFilter has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.id != null) {
            declaredFields.put("id", this.id);
        }
        if (this.searchConfiguration != null) {
            declaredFields.put("searchConfiguration", this.searchConfiguration);
        }
        if (this.dataRepositories != null) {
            declaredFields.put("dataRepositories", this.dataRepositories);
        }
        if (this.dataRepositoryType != null) {
            declaredFields.put("dataRepositoryType", (Object)this.dataRepositoryType);
        }
        if (this.dataRepositoryMetadata != null) {
            declaredFields.put("dataRepositoryMetadata", this.dataRepositoryMetadata);
        }
        if (this.documentMetadata != null) {
            declaredFields.put("documentMetadata", this.documentMetadata);
        }
        if (this.chunkMetadata != null) {
            declaredFields.put("chunkMetadata", this.chunkMetadata);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetrievalSearchFilter retrievalSearchFilter = (RetrievalSearchFilter)o;
        return Objects.equals(this.cloudSdkCustomFields, retrievalSearchFilter.cloudSdkCustomFields) && Objects.equals(this.id, retrievalSearchFilter.id) && Objects.equals(this.searchConfiguration, retrievalSearchFilter.searchConfiguration) && Objects.equals(this.dataRepositories, retrievalSearchFilter.dataRepositories) && Objects.equals((Object)this.dataRepositoryType, (Object)retrievalSearchFilter.dataRepositoryType) && Objects.equals(this.dataRepositoryMetadata, retrievalSearchFilter.dataRepositoryMetadata) && Objects.equals(this.documentMetadata, retrievalSearchFilter.documentMetadata) && Objects.equals(this.chunkMetadata, retrievalSearchFilter.chunkMetadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.searchConfiguration, this.dataRepositories, this.dataRepositoryType, this.dataRepositoryMetadata, this.documentMetadata, this.chunkMetadata, this.cloudSdkCustomFields});
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RetrievalSearchFilter {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    searchConfiguration: ").append(this.toIndentedString(this.searchConfiguration)).append("\n");
        sb.append("    dataRepositories: ").append(this.toIndentedString(this.dataRepositories)).append("\n");
        sb.append("    dataRepositoryType: ").append(this.toIndentedString((Object)this.dataRepositoryType)).append("\n");
        sb.append("    dataRepositoryMetadata: ").append(this.toIndentedString(this.dataRepositoryMetadata)).append("\n");
        sb.append("    documentMetadata: ").append(this.toIndentedString(this.documentMetadata)).append("\n");
        sb.append("    chunkMetadata: ").append(this.toIndentedString(this.chunkMetadata)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return id -> dataRepositoryType -> new RetrievalSearchFilter().id(id).dataRepositoryType(dataRepositoryType);
    }

    public static interface Builder {
        public Builder1 id(@Nonnull String var1);
    }

    public static interface Builder1 {
        public RetrievalSearchFilter dataRepositoryType(@Nullable DataRepositoryType var1);
    }
}

