/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.grounding.model.RetrievalSearchFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RetrievalSearchInput {
    @JsonProperty(value="query")
    private String query;
    @JsonProperty(value="filters")
    private List<RetrievalSearchFilter> filters = new ArrayList<RetrievalSearchFilter>();
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected RetrievalSearchInput() {
    }

    @Nonnull
    public RetrievalSearchInput query(@Nonnull String query) {
        this.query = query;
        return this;
    }

    @Nonnull
    public String getQuery() {
        return this.query;
    }

    public void setQuery(@Nonnull String query) {
        this.query = query;
    }

    @Nonnull
    public RetrievalSearchInput filters(@Nonnull List<RetrievalSearchFilter> filters) {
        this.filters = filters;
        return this;
    }

    @Nonnull
    public RetrievalSearchInput addFiltersItem(@Nonnull RetrievalSearchFilter filtersItem) {
        if (this.filters == null) {
            this.filters = new ArrayList<RetrievalSearchFilter>();
        }
        this.filters.add(filtersItem);
        return this;
    }

    @Nonnull
    public List<RetrievalSearchFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(@Nonnull List<RetrievalSearchFilter> filters) {
        this.filters = filters;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("RetrievalSearchInput has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.query != null) {
            declaredFields.put("query", this.query);
        }
        if (this.filters != null) {
            declaredFields.put("filters", this.filters);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetrievalSearchInput retrievalSearchInput = (RetrievalSearchInput)o;
        return Objects.equals(this.cloudSdkCustomFields, retrievalSearchInput.cloudSdkCustomFields) && Objects.equals(this.query, retrievalSearchInput.query) && Objects.equals(this.filters, retrievalSearchInput.filters);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.filters, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RetrievalSearchInput {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return query -> filters -> new RetrievalSearchInput().query(query).filters(filters);
    }

    public static interface Builder {
        public Builder1 query(@Nonnull String var1);
    }

    public static interface Builder1 {
        public RetrievalSearchInput filters(@Nonnull List<RetrievalSearchFilter> var1);

        default public RetrievalSearchInput filters(RetrievalSearchFilter ... filters) {
            return this.filters(Arrays.asList(filters));
        }
    }
}

