/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.grounding.model.SFTPConfigurationSftp;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class S3Configuration {
    @JsonProperty(value="destination")
    private String destination;
    @JsonProperty(value="s3")
    private SFTPConfigurationSftp s3;
    @JsonProperty(value="cronExpression")
    private String cronExpression;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected S3Configuration() {
    }

    @Nonnull
    public S3Configuration destination(@Nonnull String destination) {
        this.destination = destination;
        return this;
    }

    @Nonnull
    public String getDestination() {
        return this.destination;
    }

    public void setDestination(@Nonnull String destination) {
        this.destination = destination;
    }

    @Nonnull
    public S3Configuration s3(@Nullable SFTPConfigurationSftp s3) {
        this.s3 = s3;
        return this;
    }

    @Nonnull
    public SFTPConfigurationSftp getS3() {
        return this.s3;
    }

    public void setS3(@Nullable SFTPConfigurationSftp s3) {
        this.s3 = s3;
    }

    @Nonnull
    public S3Configuration cronExpression(@Nullable String cronExpression) {
        this.cronExpression = cronExpression;
        return this;
    }

    @Nonnull
    public String getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(@Nullable String cronExpression) {
        this.cronExpression = cronExpression;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("S3Configuration has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.destination != null) {
            declaredFields.put("destination", this.destination);
        }
        if (this.s3 != null) {
            declaredFields.put("s3", this.s3);
        }
        if (this.cronExpression != null) {
            declaredFields.put("cronExpression", this.cronExpression);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3Configuration s3Configuration = (S3Configuration)o;
        return Objects.equals(this.cloudSdkCustomFields, s3Configuration.cloudSdkCustomFields) && Objects.equals(this.destination, s3Configuration.destination) && Objects.equals(this.s3, s3Configuration.s3) && Objects.equals(this.cronExpression, s3Configuration.cronExpression);
    }

    public int hashCode() {
        return Objects.hash(this.destination, this.s3, this.cronExpression, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class S3Configuration {\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    s3: ").append(this.toIndentedString(this.s3)).append("\n");
        sb.append("    cronExpression: ").append(this.toIndentedString(this.cronExpression)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return destination -> new S3Configuration().destination(destination);
    }

    public static interface Builder {
        public S3Configuration destination(@Nonnull String var1);
    }
}

