/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.sap.ai.sdk.grounding.model.PipelineExecutionStatus;
import com.sap.ai.sdk.grounding.model.PipelineMinimalResponse;
import com.sap.ai.sdk.grounding.model.S3ConfigurationMinimal;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class S3PipelineMinimalResponse
implements PipelineMinimalResponse {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="status")
    private PipelineExecutionStatus status;
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonProperty(value="configuration")
    private S3ConfigurationMinimal _configuration;
    @JsonProperty(value="metadata")
    private Boolean metadata;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected S3PipelineMinimalResponse() {
    }

    @Nonnull
    public S3PipelineMinimalResponse id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(@Nonnull String id) {
        this.id = id;
    }

    @Nonnull
    public S3PipelineMinimalResponse status(@Nullable PipelineExecutionStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    public PipelineExecutionStatus getStatus() {
        return this.status;
    }

    public void setStatus(@Nullable PipelineExecutionStatus status) {
        this.status = status;
    }

    @Nonnull
    public S3PipelineMinimalResponse type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    @Nonnull
    public S3PipelineMinimalResponse _configuration(@Nonnull S3ConfigurationMinimal _configuration) {
        this._configuration = _configuration;
        return this;
    }

    @Nonnull
    public S3ConfigurationMinimal getConfiguration() {
        return this._configuration;
    }

    public void setConfiguration(@Nonnull S3ConfigurationMinimal _configuration) {
        this._configuration = _configuration;
    }

    @Nonnull
    public S3PipelineMinimalResponse metadata(@Nullable Boolean metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nonnull
    public Boolean isMetadata() {
        return this.metadata;
    }

    public void setMetadata(@Nullable Boolean metadata) {
        this.metadata = metadata;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("S3PipelineMinimalResponse has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.id != null) {
            declaredFields.put("id", this.id);
        }
        if (this.status != null) {
            declaredFields.put("status", (Object)this.status);
        }
        if (this.type != null) {
            declaredFields.put("type", (Object)this.type);
        }
        if (this._configuration != null) {
            declaredFields.put("_configuration", this._configuration);
        }
        if (this.metadata != null) {
            declaredFields.put("metadata", this.metadata);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        S3PipelineMinimalResponse s3PipelineMinimalResponse = (S3PipelineMinimalResponse)o;
        return Objects.equals(this.cloudSdkCustomFields, s3PipelineMinimalResponse.cloudSdkCustomFields) && Objects.equals(this.id, s3PipelineMinimalResponse.id) && Objects.equals((Object)this.status, (Object)s3PipelineMinimalResponse.status) && Objects.equals((Object)this.type, (Object)s3PipelineMinimalResponse.type) && Objects.equals(this._configuration, s3PipelineMinimalResponse._configuration) && Objects.equals(this.metadata, s3PipelineMinimalResponse.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.status, this.type, this._configuration, this.metadata, this.cloudSdkCustomFields});
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class S3PipelineMinimalResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    _configuration: ").append(this.toIndentedString(this._configuration)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return id -> status -> type -> _configuration -> new S3PipelineMinimalResponse().id(id).status(status).type(type)._configuration(_configuration);
    }

    public static enum TypeEnum {
        S3("S3"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        @Nonnull
        public String getValue() {
            return this.value;
        }

        @Nonnull
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        @Nonnull
        public static TypeEnum fromValue(@Nonnull String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static interface Builder {
        public Builder1 id(@Nonnull String var1);
    }

    public static interface Builder1 {
        public Builder2 status(@Nullable PipelineExecutionStatus var1);
    }

    public static interface Builder2 {
        public Builder3 type(@Nonnull TypeEnum var1);
    }

    public static interface Builder3 {
        public S3PipelineMinimalResponse _configuration(@Nonnull S3ConfigurationMinimal var1);
    }
}

