/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.sap.ai.sdk.grounding.model.GetPipeline;
import com.sap.ai.sdk.grounding.model.MetaData;
import com.sap.ai.sdk.grounding.model.SFTPConfiguration;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SFTPPipelineGetResponse
implements GetPipeline {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="type")
    private TypeEnum type;
    @JsonProperty(value="metadata")
    private MetaData metadata;
    @JsonProperty(value="configuration")
    private SFTPConfiguration _configuration;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected SFTPPipelineGetResponse() {
    }

    @Nonnull
    public SFTPPipelineGetResponse id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(@Nonnull String id) {
        this.id = id;
    }

    @Nonnull
    public SFTPPipelineGetResponse type(@Nonnull TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nonnull
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(@Nonnull TypeEnum type) {
        this.type = type;
    }

    @Nonnull
    public SFTPPipelineGetResponse metadata(@Nullable MetaData metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nonnull
    public MetaData getMetadata() {
        return this.metadata;
    }

    public void setMetadata(@Nullable MetaData metadata) {
        this.metadata = metadata;
    }

    @Nonnull
    public SFTPPipelineGetResponse _configuration(@Nonnull SFTPConfiguration _configuration) {
        this._configuration = _configuration;
        return this;
    }

    @Nonnull
    public SFTPConfiguration getConfiguration() {
        return this._configuration;
    }

    public void setConfiguration(@Nonnull SFTPConfiguration _configuration) {
        this._configuration = _configuration;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("SFTPPipelineGetResponse has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.id != null) {
            declaredFields.put("id", this.id);
        }
        if (this.type != null) {
            declaredFields.put("type", (Object)this.type);
        }
        if (this.metadata != null) {
            declaredFields.put("metadata", this.metadata);
        }
        if (this._configuration != null) {
            declaredFields.put("_configuration", this._configuration);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SFTPPipelineGetResponse sfTPPipelineGetResponse = (SFTPPipelineGetResponse)o;
        return Objects.equals(this.cloudSdkCustomFields, sfTPPipelineGetResponse.cloudSdkCustomFields) && Objects.equals(this.id, sfTPPipelineGetResponse.id) && Objects.equals((Object)this.type, (Object)sfTPPipelineGetResponse.type) && Objects.equals(this.metadata, sfTPPipelineGetResponse.metadata) && Objects.equals(this._configuration, sfTPPipelineGetResponse._configuration);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.type, this.metadata, this._configuration, this.cloudSdkCustomFields});
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SFTPPipelineGetResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        sb.append("    _configuration: ").append(this.toIndentedString(this._configuration)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return id -> type -> _configuration -> new SFTPPipelineGetResponse().id(id).type(type)._configuration(_configuration);
    }

    public static enum TypeEnum {
        SFTP("SFTP"),
        UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        @Nonnull
        public String getValue() {
            return this.value;
        }

        @Nonnull
        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        @Nonnull
        public static TypeEnum fromValue(@Nonnull String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return UNKNOWN_DEFAULT_OPEN_API;
        }
    }

    public static interface Builder {
        public Builder1 id(@Nonnull String var1);
    }

    public static interface Builder1 {
        public Builder2 type(@Nonnull TypeEnum var1);
    }

    public static interface Builder2 {
        public SFTPPipelineGetResponse _configuration(@Nonnull SFTPConfiguration var1);
    }
}

