/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.grounding.model.PipelineMinimalResponse;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SearchPipelinesResponse {
    @JsonProperty(value="count")
    private Integer count;
    @JsonProperty(value="resources")
    private List<PipelineMinimalResponse> resources = new ArrayList<PipelineMinimalResponse>();
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected SearchPipelinesResponse() {
    }

    @Nonnull
    public SearchPipelinesResponse count(@Nullable Integer count) {
        this.count = count;
        return this;
    }

    @Nonnull
    public Integer getCount() {
        return this.count;
    }

    public void setCount(@Nullable Integer count) {
        this.count = count;
    }

    @Nonnull
    public SearchPipelinesResponse resources(@Nonnull List<PipelineMinimalResponse> resources) {
        this.resources = resources;
        return this;
    }

    @Nonnull
    public SearchPipelinesResponse addResourcesItem(@Nonnull PipelineMinimalResponse resourcesItem) {
        if (this.resources == null) {
            this.resources = new ArrayList<PipelineMinimalResponse>();
        }
        this.resources.add(resourcesItem);
        return this;
    }

    @Nonnull
    public List<PipelineMinimalResponse> getResources() {
        return this.resources;
    }

    public void setResources(@Nonnull List<PipelineMinimalResponse> resources) {
        this.resources = resources;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("SearchPipelinesResponse has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.count != null) {
            declaredFields.put("count", this.count);
        }
        if (this.resources != null) {
            declaredFields.put("resources", this.resources);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchPipelinesResponse searchPipelinesResponse = (SearchPipelinesResponse)o;
        return Objects.equals(this.cloudSdkCustomFields, searchPipelinesResponse.cloudSdkCustomFields) && Objects.equals(this.count, searchPipelinesResponse.count) && Objects.equals(this.resources, searchPipelinesResponse.resources);
    }

    public int hashCode() {
        return Objects.hash(this.count, this.resources, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SearchPipelinesResponse {\n");
        sb.append("    count: ").append(this.toIndentedString(this.count)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return resources -> new SearchPipelinesResponse().resources(resources);
    }

    public static interface Builder {
        public SearchPipelinesResponse resources(@Nonnull List<PipelineMinimalResponse> var1);

        default public SearchPipelinesResponse resources(PipelineMinimalResponse ... resources) {
            return this.resources(Arrays.asList(resources));
        }
    }
}

