/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SharePointSite {
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="includePaths")
    private List<String> includePaths = new ArrayList<String>();
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected SharePointSite() {
    }

    @Nonnull
    public SharePointSite name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    @Nonnull
    public SharePointSite includePaths(@Nullable List<String> includePaths) {
        this.includePaths = includePaths;
        return this;
    }

    @Nonnull
    public SharePointSite addIncludePathsItem(@Nonnull String includePathsItem) {
        if (this.includePaths == null) {
            this.includePaths = new ArrayList<String>();
        }
        this.includePaths.add(includePathsItem);
        return this;
    }

    @Nonnull
    public List<String> getIncludePaths() {
        return this.includePaths;
    }

    public void setIncludePaths(@Nullable List<String> includePaths) {
        this.includePaths = includePaths;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("SharePointSite has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.name != null) {
            declaredFields.put("name", this.name);
        }
        if (this.includePaths != null) {
            declaredFields.put("includePaths", this.includePaths);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SharePointSite sharePointSite = (SharePointSite)o;
        return Objects.equals(this.cloudSdkCustomFields, sharePointSite.cloudSdkCustomFields) && Objects.equals(this.name, sharePointSite.name) && Objects.equals(this.includePaths, sharePointSite.includePaths);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.includePaths, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SharePointSite {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    includePaths: ").append(this.toIndentedString(this.includePaths)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return name -> new SharePointSite().name(name);
    }

    public static interface Builder {
        public SharePointSite name(@Nonnull String var1);
    }
}

