/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.grounding.model.VectorSearchFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TextSearchRequest {
    @JsonProperty(value="query")
    private String query;
    @JsonProperty(value="filters")
    private List<VectorSearchFilter> filters = new ArrayList<VectorSearchFilter>();
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected TextSearchRequest() {
    }

    @Nonnull
    public TextSearchRequest query(@Nonnull String query) {
        this.query = query;
        return this;
    }

    @Nonnull
    public String getQuery() {
        return this.query;
    }

    public void setQuery(@Nonnull String query) {
        this.query = query;
    }

    @Nonnull
    public TextSearchRequest filters(@Nonnull List<VectorSearchFilter> filters) {
        this.filters = filters;
        return this;
    }

    @Nonnull
    public TextSearchRequest addFiltersItem(@Nonnull VectorSearchFilter filtersItem) {
        if (this.filters == null) {
            this.filters = new ArrayList<VectorSearchFilter>();
        }
        this.filters.add(filtersItem);
        return this;
    }

    @Nonnull
    public List<VectorSearchFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(@Nonnull List<VectorSearchFilter> filters) {
        this.filters = filters;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("TextSearchRequest has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.query != null) {
            declaredFields.put("query", this.query);
        }
        if (this.filters != null) {
            declaredFields.put("filters", this.filters);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextSearchRequest textSearchRequest = (TextSearchRequest)o;
        return Objects.equals(this.cloudSdkCustomFields, textSearchRequest.cloudSdkCustomFields) && Objects.equals(this.query, textSearchRequest.query) && Objects.equals(this.filters, textSearchRequest.filters);
    }

    public int hashCode() {
        return Objects.hash(this.query, this.filters, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TextSearchRequest {\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    filters: ").append(this.toIndentedString(this.filters)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return query -> filters -> new TextSearchRequest().query(query).filters(filters);
    }

    public static interface Builder {
        public Builder1 query(@Nonnull String var1);
    }

    public static interface Builder1 {
        public TextSearchRequest filters(@Nonnull List<VectorSearchFilter> var1);

        default public TextSearchRequest filters(VectorSearchFilter ... filters) {
            return this.filters(Arrays.asList(filters));
        }
    }
}

