/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ValidationError {
    @JsonProperty(value="loc")
    private List<String> loc = new ArrayList<String>();
    @JsonProperty(value="msg")
    private String msg;
    @JsonProperty(value="type")
    private String type;
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected ValidationError() {
    }

    @Nonnull
    public ValidationError loc(@Nonnull List<String> loc) {
        this.loc = loc;
        return this;
    }

    @Nonnull
    public ValidationError addLocItem(@Nonnull String locItem) {
        if (this.loc == null) {
            this.loc = new ArrayList<String>();
        }
        this.loc.add(locItem);
        return this;
    }

    @Nonnull
    public List<String> getLoc() {
        return this.loc;
    }

    public void setLoc(@Nonnull List<String> loc) {
        this.loc = loc;
    }

    @Nonnull
    public ValidationError msg(@Nonnull String msg) {
        this.msg = msg;
        return this;
    }

    @Nonnull
    public String getMsg() {
        return this.msg;
    }

    public void setMsg(@Nonnull String msg) {
        this.msg = msg;
    }

    @Nonnull
    public ValidationError type(@Nonnull String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    public String getType() {
        return this.type;
    }

    public void setType(@Nonnull String type) {
        this.type = type;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("ValidationError has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.loc != null) {
            declaredFields.put("loc", this.loc);
        }
        if (this.msg != null) {
            declaredFields.put("msg", this.msg);
        }
        if (this.type != null) {
            declaredFields.put("type", this.type);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ValidationError validationError = (ValidationError)o;
        return Objects.equals(this.cloudSdkCustomFields, validationError.cloudSdkCustomFields) && Objects.equals(this.loc, validationError.loc) && Objects.equals(this.msg, validationError.msg) && Objects.equals(this.type, validationError.type);
    }

    public int hashCode() {
        return Objects.hash(this.loc, this.msg, this.type, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ValidationError {\n");
        sb.append("    loc: ").append(this.toIndentedString(this.loc)).append("\n");
        sb.append("    msg: ").append(this.toIndentedString(this.msg)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return loc -> msg -> type -> new ValidationError().loc(loc).msg(msg).type(type);
    }

    public static interface Builder {
        public Builder1 loc(@Nonnull List<String> var1);

        default public Builder1 loc(String ... loc) {
            return this.loc(Arrays.asList(loc));
        }
    }

    public static interface Builder1 {
        public Builder2 msg(@Nonnull String var1);
    }

    public static interface Builder2 {
        public ValidationError type(@Nonnull String var1);
    }
}

