/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.grounding.model.VectorKeyValueListPair;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VectorChunk {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="content")
    private String content;
    @JsonProperty(value="metadata")
    private List<VectorKeyValueListPair> metadata = new ArrayList<VectorKeyValueListPair>();
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected VectorChunk() {
    }

    @Nonnull
    public VectorChunk id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(@Nonnull String id) {
        this.id = id;
    }

    @Nonnull
    public VectorChunk content(@Nonnull String content) {
        this.content = content;
        return this;
    }

    @Nonnull
    public String getContent() {
        return this.content;
    }

    public void setContent(@Nonnull String content) {
        this.content = content;
    }

    @Nonnull
    public VectorChunk metadata(@Nullable List<VectorKeyValueListPair> metadata) {
        this.metadata = metadata;
        return this;
    }

    @Nonnull
    public VectorChunk addMetadataItem(@Nonnull VectorKeyValueListPair metadataItem) {
        if (this.metadata == null) {
            this.metadata = new ArrayList<VectorKeyValueListPair>();
        }
        this.metadata.add(metadataItem);
        return this;
    }

    @Nonnull
    public List<VectorKeyValueListPair> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(@Nullable List<VectorKeyValueListPair> metadata) {
        this.metadata = metadata;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("VectorChunk has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.id != null) {
            declaredFields.put("id", this.id);
        }
        if (this.content != null) {
            declaredFields.put("content", this.content);
        }
        if (this.metadata != null) {
            declaredFields.put("metadata", this.metadata);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VectorChunk vectorChunk = (VectorChunk)o;
        return Objects.equals(this.cloudSdkCustomFields, vectorChunk.cloudSdkCustomFields) && Objects.equals(this.id, vectorChunk.id) && Objects.equals(this.content, vectorChunk.content) && Objects.equals(this.metadata, vectorChunk.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.content, this.metadata, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VectorChunk {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    content: ").append(this.toIndentedString(this.content)).append("\n");
        sb.append("    metadata: ").append(this.toIndentedString(this.metadata)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return id -> content -> new VectorChunk().id(id).content(content);
    }

    public static interface Builder {
        public Builder1 id(@Nonnull String var1);
    }

    public static interface Builder1 {
        public VectorChunk content(@Nonnull String var1);
    }
}

