/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VectorKeyValueListPair {
    @JsonProperty(value="key")
    private String key;
    @JsonProperty(value="value")
    private List<String> value = new ArrayList<String>();
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected VectorKeyValueListPair() {
    }

    @Nonnull
    public VectorKeyValueListPair key(@Nonnull String key) {
        this.key = key;
        return this;
    }

    @Nonnull
    public String getKey() {
        return this.key;
    }

    public void setKey(@Nonnull String key) {
        this.key = key;
    }

    @Nonnull
    public VectorKeyValueListPair value(@Nonnull List<String> value) {
        this.value = value;
        return this;
    }

    @Nonnull
    public VectorKeyValueListPair addValueItem(@Nonnull String valueItem) {
        if (this.value == null) {
            this.value = new ArrayList<String>();
        }
        this.value.add(valueItem);
        return this;
    }

    @Nonnull
    public List<String> getValue() {
        return this.value;
    }

    public void setValue(@Nonnull List<String> value) {
        this.value = value;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("VectorKeyValueListPair has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.key != null) {
            declaredFields.put("key", this.key);
        }
        if (this.value != null) {
            declaredFields.put("value", this.value);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VectorKeyValueListPair vectorKeyValueListPair = (VectorKeyValueListPair)o;
        return Objects.equals(this.cloudSdkCustomFields, vectorKeyValueListPair.cloudSdkCustomFields) && Objects.equals(this.key, vectorKeyValueListPair.key) && Objects.equals(this.value, vectorKeyValueListPair.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.value, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VectorKeyValueListPair {\n");
        sb.append("    key: ").append(this.toIndentedString(this.key)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return key -> value -> new VectorKeyValueListPair().key(key).value(value);
    }

    public static interface Builder {
        public Builder1 key(@Nonnull String var1);
    }

    public static interface Builder1 {
        public VectorKeyValueListPair value(@Nonnull List<String> var1);

        default public VectorKeyValueListPair value(String ... value) {
            return this.value(Arrays.asList(value));
        }
    }
}

