/*
 * Decompiled with CFR 0.152.
 */
package com.sap.ai.sdk.grounding.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sap.ai.sdk.grounding.model.VectorKeyValueListPair;
import com.sap.ai.sdk.grounding.model.VectorSearchConfiguration;
import com.sap.ai.sdk.grounding.model.VectorSearchDocumentKeyValueListPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class VectorSearchFilter {
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="collectionIds")
    private List<String> collectionIds = new ArrayList<String>();
    @JsonProperty(value="configuration")
    private VectorSearchConfiguration _configuration;
    @JsonProperty(value="collectionMetadata")
    private List<VectorKeyValueListPair> collectionMetadata = new ArrayList<VectorKeyValueListPair>();
    @JsonProperty(value="documentMetadata")
    private List<VectorSearchDocumentKeyValueListPair> documentMetadata = new ArrayList<VectorSearchDocumentKeyValueListPair>();
    @JsonProperty(value="chunkMetadata")
    private List<VectorKeyValueListPair> chunkMetadata = new ArrayList<VectorKeyValueListPair>();
    @JsonAnySetter
    @JsonAnyGetter
    private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<String, Object>();

    protected VectorSearchFilter() {
    }

    @Nonnull
    public VectorSearchFilter id(@Nonnull String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    public void setId(@Nonnull String id) {
        this.id = id;
    }

    @Nonnull
    public VectorSearchFilter collectionIds(@Nonnull List<String> collectionIds) {
        this.collectionIds = collectionIds;
        return this;
    }

    @Nonnull
    public VectorSearchFilter addCollectionIdsItem(@Nonnull String collectionIdsItem) {
        if (this.collectionIds == null) {
            this.collectionIds = new ArrayList<String>();
        }
        this.collectionIds.add(collectionIdsItem);
        return this;
    }

    @Nonnull
    public List<String> getCollectionIds() {
        return this.collectionIds;
    }

    public void setCollectionIds(@Nonnull List<String> collectionIds) {
        this.collectionIds = collectionIds;
    }

    @Nonnull
    public VectorSearchFilter _configuration(@Nonnull VectorSearchConfiguration _configuration) {
        this._configuration = _configuration;
        return this;
    }

    @Nonnull
    public VectorSearchConfiguration getConfiguration() {
        return this._configuration;
    }

    public void setConfiguration(@Nonnull VectorSearchConfiguration _configuration) {
        this._configuration = _configuration;
    }

    @Nonnull
    public VectorSearchFilter collectionMetadata(@Nullable List<VectorKeyValueListPair> collectionMetadata) {
        this.collectionMetadata = collectionMetadata;
        return this;
    }

    @Nonnull
    public VectorSearchFilter addCollectionMetadataItem(@Nonnull VectorKeyValueListPair collectionMetadataItem) {
        if (this.collectionMetadata == null) {
            this.collectionMetadata = new ArrayList<VectorKeyValueListPair>();
        }
        this.collectionMetadata.add(collectionMetadataItem);
        return this;
    }

    @Nonnull
    public List<VectorKeyValueListPair> getCollectionMetadata() {
        return this.collectionMetadata;
    }

    public void setCollectionMetadata(@Nullable List<VectorKeyValueListPair> collectionMetadata) {
        this.collectionMetadata = collectionMetadata;
    }

    @Nonnull
    public VectorSearchFilter documentMetadata(@Nullable List<VectorSearchDocumentKeyValueListPair> documentMetadata) {
        this.documentMetadata = documentMetadata;
        return this;
    }

    @Nonnull
    public VectorSearchFilter addDocumentMetadataItem(@Nonnull VectorSearchDocumentKeyValueListPair documentMetadataItem) {
        if (this.documentMetadata == null) {
            this.documentMetadata = new ArrayList<VectorSearchDocumentKeyValueListPair>();
        }
        this.documentMetadata.add(documentMetadataItem);
        return this;
    }

    @Nonnull
    public List<VectorSearchDocumentKeyValueListPair> getDocumentMetadata() {
        return this.documentMetadata;
    }

    public void setDocumentMetadata(@Nullable List<VectorSearchDocumentKeyValueListPair> documentMetadata) {
        this.documentMetadata = documentMetadata;
    }

    @Nonnull
    public VectorSearchFilter chunkMetadata(@Nullable List<VectorKeyValueListPair> chunkMetadata) {
        this.chunkMetadata = chunkMetadata;
        return this;
    }

    @Nonnull
    public VectorSearchFilter addChunkMetadataItem(@Nonnull VectorKeyValueListPair chunkMetadataItem) {
        if (this.chunkMetadata == null) {
            this.chunkMetadata = new ArrayList<VectorKeyValueListPair>();
        }
        this.chunkMetadata.add(chunkMetadataItem);
        return this;
    }

    @Nonnull
    public List<VectorKeyValueListPair> getChunkMetadata() {
        return this.chunkMetadata;
    }

    public void setChunkMetadata(@Nullable List<VectorKeyValueListPair> chunkMetadata) {
        this.chunkMetadata = chunkMetadata;
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getCustomFieldNames() {
        return this.cloudSdkCustomFields.keySet();
    }

    @Nullable
    @Deprecated
    public Object getCustomField(@Nonnull String name) throws NoSuchElementException {
        if (!this.cloudSdkCustomFields.containsKey(name)) {
            throw new NoSuchElementException("VectorSearchFilter has no field with name '" + name + "'.");
        }
        return this.cloudSdkCustomFields.get(name);
    }

    @JsonIgnore
    @Nonnull
    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> declaredFields = new LinkedHashMap<String, Object>(this.cloudSdkCustomFields);
        if (this.id != null) {
            declaredFields.put("id", this.id);
        }
        if (this.collectionIds != null) {
            declaredFields.put("collectionIds", this.collectionIds);
        }
        if (this._configuration != null) {
            declaredFields.put("_configuration", this._configuration);
        }
        if (this.collectionMetadata != null) {
            declaredFields.put("collectionMetadata", this.collectionMetadata);
        }
        if (this.documentMetadata != null) {
            declaredFields.put("documentMetadata", this.documentMetadata);
        }
        if (this.chunkMetadata != null) {
            declaredFields.put("chunkMetadata", this.chunkMetadata);
        }
        return declaredFields;
    }

    @JsonIgnore
    public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
        this.cloudSdkCustomFields.put(customFieldName, customFieldValue);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VectorSearchFilter vectorSearchFilter = (VectorSearchFilter)o;
        return Objects.equals(this.cloudSdkCustomFields, vectorSearchFilter.cloudSdkCustomFields) && Objects.equals(this.id, vectorSearchFilter.id) && Objects.equals(this.collectionIds, vectorSearchFilter.collectionIds) && Objects.equals(this._configuration, vectorSearchFilter._configuration) && Objects.equals(this.collectionMetadata, vectorSearchFilter.collectionMetadata) && Objects.equals(this.documentMetadata, vectorSearchFilter.documentMetadata) && Objects.equals(this.chunkMetadata, vectorSearchFilter.chunkMetadata);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.collectionIds, this._configuration, this.collectionMetadata, this.documentMetadata, this.chunkMetadata, this.cloudSdkCustomFields);
    }

    @Nonnull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class VectorSearchFilter {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    collectionIds: ").append(this.toIndentedString(this.collectionIds)).append("\n");
        sb.append("    _configuration: ").append(this.toIndentedString(this._configuration)).append("\n");
        sb.append("    collectionMetadata: ").append(this.toIndentedString(this.collectionMetadata)).append("\n");
        sb.append("    documentMetadata: ").append(this.toIndentedString(this.documentMetadata)).append("\n");
        sb.append("    chunkMetadata: ").append(this.toIndentedString(this.chunkMetadata)).append("\n");
        this.cloudSdkCustomFields.forEach((k, v) -> sb.append("    ").append((String)k).append(": ").append(this.toIndentedString(v)).append("\n"));
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static Builder create() {
        return id -> collectionIds -> _configuration -> new VectorSearchFilter().id(id).collectionIds(collectionIds)._configuration(_configuration);
    }

    public static interface Builder {
        public Builder1 id(@Nonnull String var1);
    }

    public static interface Builder1 {
        public Builder2 collectionIds(@Nonnull List<String> var1);

        default public Builder2 collectionIds(String ... collectionIds) {
            return this.collectionIds(Arrays.asList(collectionIds));
        }
    }

    public static interface Builder2 {
        public VectorSearchFilter _configuration(@Nonnull VectorSearchConfiguration var1);
    }
}

