/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/** Filter configuration for Azure Content Safety */
// CHECKSTYLE:OFF
public class AzureContentSafetyInput
// CHECKSTYLE:ON
{
  @JsonProperty("Hate")
  private AzureThreshold hate;

  @JsonProperty("SelfHarm")
  private AzureThreshold selfHarm;

  @JsonProperty("Sexual")
  private AzureThreshold sexual;

  @JsonProperty("Violence")
  private AzureThreshold violence;

  @JsonProperty("PromptShield")
  private Boolean promptShield = false;

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for AzureContentSafetyInput. */
  protected AzureContentSafetyInput() {}

  /**
   * Set the hate of this {@link AzureContentSafetyInput} instance and return the same instance.
   *
   * @param hate The hate of this {@link AzureContentSafetyInput}
   * @return The same instance of this {@link AzureContentSafetyInput} class
   */
  @Nonnull
  public AzureContentSafetyInput hate(@Nullable final AzureThreshold hate) {
    this.hate = hate;
    return this;
  }

  /**
   * Get hate
   *
   * @return hate The hate of this {@link AzureContentSafetyInput} instance.
   */
  @Nonnull
  public AzureThreshold getHate() {
    return hate;
  }

  /**
   * Set the hate of this {@link AzureContentSafetyInput} instance.
   *
   * @param hate The hate of this {@link AzureContentSafetyInput}
   */
  public void setHate(@Nullable final AzureThreshold hate) {
    this.hate = hate;
  }

  /**
   * Set the selfHarm of this {@link AzureContentSafetyInput} instance and return the same instance.
   *
   * @param selfHarm The selfHarm of this {@link AzureContentSafetyInput}
   * @return The same instance of this {@link AzureContentSafetyInput} class
   */
  @Nonnull
  public AzureContentSafetyInput selfHarm(@Nullable final AzureThreshold selfHarm) {
    this.selfHarm = selfHarm;
    return this;
  }

  /**
   * Get selfHarm
   *
   * @return selfHarm The selfHarm of this {@link AzureContentSafetyInput} instance.
   */
  @Nonnull
  public AzureThreshold getSelfHarm() {
    return selfHarm;
  }

  /**
   * Set the selfHarm of this {@link AzureContentSafetyInput} instance.
   *
   * @param selfHarm The selfHarm of this {@link AzureContentSafetyInput}
   */
  public void setSelfHarm(@Nullable final AzureThreshold selfHarm) {
    this.selfHarm = selfHarm;
  }

  /**
   * Set the sexual of this {@link AzureContentSafetyInput} instance and return the same instance.
   *
   * @param sexual The sexual of this {@link AzureContentSafetyInput}
   * @return The same instance of this {@link AzureContentSafetyInput} class
   */
  @Nonnull
  public AzureContentSafetyInput sexual(@Nullable final AzureThreshold sexual) {
    this.sexual = sexual;
    return this;
  }

  /**
   * Get sexual
   *
   * @return sexual The sexual of this {@link AzureContentSafetyInput} instance.
   */
  @Nonnull
  public AzureThreshold getSexual() {
    return sexual;
  }

  /**
   * Set the sexual of this {@link AzureContentSafetyInput} instance.
   *
   * @param sexual The sexual of this {@link AzureContentSafetyInput}
   */
  public void setSexual(@Nullable final AzureThreshold sexual) {
    this.sexual = sexual;
  }

  /**
   * Set the violence of this {@link AzureContentSafetyInput} instance and return the same instance.
   *
   * @param violence The violence of this {@link AzureContentSafetyInput}
   * @return The same instance of this {@link AzureContentSafetyInput} class
   */
  @Nonnull
  public AzureContentSafetyInput violence(@Nullable final AzureThreshold violence) {
    this.violence = violence;
    return this;
  }

  /**
   * Get violence
   *
   * @return violence The violence of this {@link AzureContentSafetyInput} instance.
   */
  @Nonnull
  public AzureThreshold getViolence() {
    return violence;
  }

  /**
   * Set the violence of this {@link AzureContentSafetyInput} instance.
   *
   * @param violence The violence of this {@link AzureContentSafetyInput}
   */
  public void setViolence(@Nullable final AzureThreshold violence) {
    this.violence = violence;
  }

  /**
   * Set the promptShield of this {@link AzureContentSafetyInput} instance and return the same
   * instance.
   *
   * @param promptShield A flag to use prompt shield
   * @return The same instance of this {@link AzureContentSafetyInput} class
   */
  @Nonnull
  public AzureContentSafetyInput promptShield(@Nullable final Boolean promptShield) {
    this.promptShield = promptShield;
    return this;
  }

  /**
   * A flag to use prompt shield
   *
   * @return promptShield The promptShield of this {@link AzureContentSafetyInput} instance.
   */
  @Nonnull
  public Boolean isPromptShield() {
    return promptShield;
  }

  /**
   * Set the promptShield of this {@link AzureContentSafetyInput} instance.
   *
   * @param promptShield A flag to use prompt shield
   */
  public void setPromptShield(@Nullable final Boolean promptShield) {
    this.promptShield = promptShield;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link AzureContentSafetyInput}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link AzureContentSafetyInput} instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException(
          "AzureContentSafetyInput has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link AzureContentSafetyInput} instance including
   * unrecognized properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (hate != null) declaredFields.put("hate", hate);
    if (selfHarm != null) declaredFields.put("selfHarm", selfHarm);
    if (sexual != null) declaredFields.put("sexual", sexual);
    if (violence != null) declaredFields.put("violence", violence);
    if (promptShield != null) declaredFields.put("promptShield", promptShield);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link AzureContentSafetyInput} instance. If the map
   * previously contained a mapping for the key, the old value is replaced by the specified value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final AzureContentSafetyInput azureContentSafetyInput = (AzureContentSafetyInput) o;
    return Objects.equals(this.cloudSdkCustomFields, azureContentSafetyInput.cloudSdkCustomFields)
        && Objects.equals(this.hate, azureContentSafetyInput.hate)
        && Objects.equals(this.selfHarm, azureContentSafetyInput.selfHarm)
        && Objects.equals(this.sexual, azureContentSafetyInput.sexual)
        && Objects.equals(this.violence, azureContentSafetyInput.violence)
        && Objects.equals(this.promptShield, azureContentSafetyInput.promptShield);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hate, selfHarm, sexual, violence, promptShield, cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class AzureContentSafetyInput {\n");
    sb.append("    hate: ").append(toIndentedString(hate)).append("\n");
    sb.append("    selfHarm: ").append(toIndentedString(selfHarm)).append("\n");
    sb.append("    sexual: ").append(toIndentedString(sexual)).append("\n");
    sb.append("    violence: ").append(toIndentedString(violence)).append("\n");
    sb.append("    promptShield: ").append(toIndentedString(promptShield)).append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /** Create a new {@link AzureContentSafetyInput} instance. No arguments are required. */
  public static AzureContentSafetyInput create() {
    return new AzureContentSafetyInput();
  }
}
