/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/** Filter configuration for Azure Content Safety */
// CHECKSTYLE:OFF
public class AzureContentSafetyOutput
// CHECKSTYLE:ON
{
  @JsonProperty("Hate")
  private AzureThreshold hate;

  @JsonProperty("SelfHarm")
  private AzureThreshold selfHarm;

  @JsonProperty("Sexual")
  private AzureThreshold sexual;

  @JsonProperty("Violence")
  private AzureThreshold violence;

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for AzureContentSafetyOutput. */
  protected AzureContentSafetyOutput() {}

  /**
   * Set the hate of this {@link AzureContentSafetyOutput} instance and return the same instance.
   *
   * @param hate The hate of this {@link AzureContentSafetyOutput}
   * @return The same instance of this {@link AzureContentSafetyOutput} class
   */
  @Nonnull
  public AzureContentSafetyOutput hate(@Nullable final AzureThreshold hate) {
    this.hate = hate;
    return this;
  }

  /**
   * Get hate
   *
   * @return hate The hate of this {@link AzureContentSafetyOutput} instance.
   */
  @Nonnull
  public AzureThreshold getHate() {
    return hate;
  }

  /**
   * Set the hate of this {@link AzureContentSafetyOutput} instance.
   *
   * @param hate The hate of this {@link AzureContentSafetyOutput}
   */
  public void setHate(@Nullable final AzureThreshold hate) {
    this.hate = hate;
  }

  /**
   * Set the selfHarm of this {@link AzureContentSafetyOutput} instance and return the same
   * instance.
   *
   * @param selfHarm The selfHarm of this {@link AzureContentSafetyOutput}
   * @return The same instance of this {@link AzureContentSafetyOutput} class
   */
  @Nonnull
  public AzureContentSafetyOutput selfHarm(@Nullable final AzureThreshold selfHarm) {
    this.selfHarm = selfHarm;
    return this;
  }

  /**
   * Get selfHarm
   *
   * @return selfHarm The selfHarm of this {@link AzureContentSafetyOutput} instance.
   */
  @Nonnull
  public AzureThreshold getSelfHarm() {
    return selfHarm;
  }

  /**
   * Set the selfHarm of this {@link AzureContentSafetyOutput} instance.
   *
   * @param selfHarm The selfHarm of this {@link AzureContentSafetyOutput}
   */
  public void setSelfHarm(@Nullable final AzureThreshold selfHarm) {
    this.selfHarm = selfHarm;
  }

  /**
   * Set the sexual of this {@link AzureContentSafetyOutput} instance and return the same instance.
   *
   * @param sexual The sexual of this {@link AzureContentSafetyOutput}
   * @return The same instance of this {@link AzureContentSafetyOutput} class
   */
  @Nonnull
  public AzureContentSafetyOutput sexual(@Nullable final AzureThreshold sexual) {
    this.sexual = sexual;
    return this;
  }

  /**
   * Get sexual
   *
   * @return sexual The sexual of this {@link AzureContentSafetyOutput} instance.
   */
  @Nonnull
  public AzureThreshold getSexual() {
    return sexual;
  }

  /**
   * Set the sexual of this {@link AzureContentSafetyOutput} instance.
   *
   * @param sexual The sexual of this {@link AzureContentSafetyOutput}
   */
  public void setSexual(@Nullable final AzureThreshold sexual) {
    this.sexual = sexual;
  }

  /**
   * Set the violence of this {@link AzureContentSafetyOutput} instance and return the same
   * instance.
   *
   * @param violence The violence of this {@link AzureContentSafetyOutput}
   * @return The same instance of this {@link AzureContentSafetyOutput} class
   */
  @Nonnull
  public AzureContentSafetyOutput violence(@Nullable final AzureThreshold violence) {
    this.violence = violence;
    return this;
  }

  /**
   * Get violence
   *
   * @return violence The violence of this {@link AzureContentSafetyOutput} instance.
   */
  @Nonnull
  public AzureThreshold getViolence() {
    return violence;
  }

  /**
   * Set the violence of this {@link AzureContentSafetyOutput} instance.
   *
   * @param violence The violence of this {@link AzureContentSafetyOutput}
   */
  public void setViolence(@Nullable final AzureThreshold violence) {
    this.violence = violence;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link AzureContentSafetyOutput}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link AzureContentSafetyOutput} instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException(
          "AzureContentSafetyOutput has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link AzureContentSafetyOutput} instance including
   * unrecognized properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (hate != null) declaredFields.put("hate", hate);
    if (selfHarm != null) declaredFields.put("selfHarm", selfHarm);
    if (sexual != null) declaredFields.put("sexual", sexual);
    if (violence != null) declaredFields.put("violence", violence);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link AzureContentSafetyOutput} instance. If the map
   * previously contained a mapping for the key, the old value is replaced by the specified value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final AzureContentSafetyOutput azureContentSafetyOutput = (AzureContentSafetyOutput) o;
    return Objects.equals(this.cloudSdkCustomFields, azureContentSafetyOutput.cloudSdkCustomFields)
        && Objects.equals(this.hate, azureContentSafetyOutput.hate)
        && Objects.equals(this.selfHarm, azureContentSafetyOutput.selfHarm)
        && Objects.equals(this.sexual, azureContentSafetyOutput.sexual)
        && Objects.equals(this.violence, azureContentSafetyOutput.violence);
  }

  @Override
  public int hashCode() {
    return Objects.hash(hate, selfHarm, sexual, violence, cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class AzureContentSafetyOutput {\n");
    sb.append("    hate: ").append(toIndentedString(hate)).append("\n");
    sb.append("    selfHarm: ").append(toIndentedString(selfHarm)).append("\n");
    sb.append("    sexual: ").append(toIndentedString(sexual)).append("\n");
    sb.append("    violence: ").append(toIndentedString(violence)).append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /** Create a new {@link AzureContentSafetyOutput} instance. No arguments are required. */
  public static AzureContentSafetyOutput create() {
    return new AzureContentSafetyOutput();
  }
}
