/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/** Log probabilities for the choice. */
// CHECKSTYLE:OFF
public class ChoiceLogprobs
// CHECKSTYLE:ON
{
  @JsonProperty("content")
  private List<ChatCompletionTokenLogprob> content = new ArrayList<>();

  @JsonProperty("refusal")
  private List<ChatCompletionTokenLogprob> refusal = new ArrayList<>();

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for ChoiceLogprobs. */
  protected ChoiceLogprobs() {}

  /**
   * Set the content of this {@link ChoiceLogprobs} instance and return the same instance.
   *
   * @param content A list of message content tokens with log probability information.
   * @return The same instance of this {@link ChoiceLogprobs} class
   */
  @Nonnull
  public ChoiceLogprobs content(@Nullable final List<ChatCompletionTokenLogprob> content) {
    this.content = content;
    return this;
  }

  /**
   * Add one content instance to this {@link ChoiceLogprobs}.
   *
   * @param contentItem The content that should be added
   * @return The same instance of type {@link ChoiceLogprobs}
   */
  @Nonnull
  public ChoiceLogprobs addContentItem(@Nonnull final ChatCompletionTokenLogprob contentItem) {
    if (this.content == null) {
      this.content = new ArrayList<>();
    }
    this.content.add(contentItem);
    return this;
  }

  /**
   * A list of message content tokens with log probability information.
   *
   * @return content The content of this {@link ChoiceLogprobs} instance.
   */
  @Nonnull
  public List<ChatCompletionTokenLogprob> getContent() {
    return content;
  }

  /**
   * Set the content of this {@link ChoiceLogprobs} instance.
   *
   * @param content A list of message content tokens with log probability information.
   */
  public void setContent(@Nullable final List<ChatCompletionTokenLogprob> content) {
    this.content = content;
  }

  /**
   * Set the refusal of this {@link ChoiceLogprobs} instance and return the same instance.
   *
   * @param refusal A list of message refusal tokens with log probability information.
   * @return The same instance of this {@link ChoiceLogprobs} class
   */
  @Nonnull
  public ChoiceLogprobs refusal(@Nullable final List<ChatCompletionTokenLogprob> refusal) {
    this.refusal = refusal;
    return this;
  }

  /**
   * Add one refusal instance to this {@link ChoiceLogprobs}.
   *
   * @param refusalItem The refusal that should be added
   * @return The same instance of type {@link ChoiceLogprobs}
   */
  @Nonnull
  public ChoiceLogprobs addRefusalItem(@Nonnull final ChatCompletionTokenLogprob refusalItem) {
    if (this.refusal == null) {
      this.refusal = new ArrayList<>();
    }
    this.refusal.add(refusalItem);
    return this;
  }

  /**
   * A list of message refusal tokens with log probability information.
   *
   * @return refusal The refusal of this {@link ChoiceLogprobs} instance.
   */
  @Nonnull
  public List<ChatCompletionTokenLogprob> getRefusal() {
    return refusal;
  }

  /**
   * Set the refusal of this {@link ChoiceLogprobs} instance.
   *
   * @param refusal A list of message refusal tokens with log probability information.
   */
  public void setRefusal(@Nullable final List<ChatCompletionTokenLogprob> refusal) {
    this.refusal = refusal;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link ChoiceLogprobs}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link ChoiceLogprobs} instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException("ChoiceLogprobs has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link ChoiceLogprobs} instance including unrecognized
   * properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (content != null) declaredFields.put("content", content);
    if (refusal != null) declaredFields.put("refusal", refusal);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link ChoiceLogprobs} instance. If the map previously
   * contained a mapping for the key, the old value is replaced by the specified value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final ChoiceLogprobs choiceLogprobs = (ChoiceLogprobs) o;
    return Objects.equals(this.cloudSdkCustomFields, choiceLogprobs.cloudSdkCustomFields)
        && Objects.equals(this.content, choiceLogprobs.content)
        && Objects.equals(this.refusal, choiceLogprobs.refusal);
  }

  @Override
  public int hashCode() {
    return Objects.hash(content, refusal, cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class ChoiceLogprobs {\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    refusal: ").append(toIndentedString(refusal)).append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /** Create a new {@link ChoiceLogprobs} instance. No arguments are required. */
  public static ChoiceLogprobs create() {
    return new ChoiceLogprobs();
  }
}
