/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/** DPICustomEntity */
// CHECKSTYLE:OFF
public class DPICustomEntity implements DPIEntityConfig
// CHECKSTYLE:ON
{
  @JsonProperty("regex")
  private String regex;

  @JsonProperty("replacement_strategy")
  private DPIMethodConstant replacementStrategy;

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for DPICustomEntity. */
  protected DPICustomEntity() {}

  /**
   * Set the regex of this {@link DPICustomEntity} instance and return the same instance.
   *
   * @param regex Regular expression to match the entity
   * @return The same instance of this {@link DPICustomEntity} class
   */
  @Nonnull
  public DPICustomEntity regex(@Nonnull final String regex) {
    this.regex = regex;
    return this;
  }

  /**
   * Regular expression to match the entity
   *
   * @return regex The regex of this {@link DPICustomEntity} instance.
   */
  @Nonnull
  public String getRegex() {
    return regex;
  }

  /**
   * Set the regex of this {@link DPICustomEntity} instance.
   *
   * @param regex Regular expression to match the entity
   */
  public void setRegex(@Nonnull final String regex) {
    this.regex = regex;
  }

  /**
   * Set the replacementStrategy of this {@link DPICustomEntity} instance and return the same
   * instance.
   *
   * @param replacementStrategy The replacementStrategy of this {@link DPICustomEntity}
   * @return The same instance of this {@link DPICustomEntity} class
   */
  @Nonnull
  public DPICustomEntity replacementStrategy(@Nonnull final DPIMethodConstant replacementStrategy) {
    this.replacementStrategy = replacementStrategy;
    return this;
  }

  /**
   * Get replacementStrategy
   *
   * @return replacementStrategy The replacementStrategy of this {@link DPICustomEntity} instance.
   */
  @Nonnull
  public DPIMethodConstant getReplacementStrategy() {
    return replacementStrategy;
  }

  /**
   * Set the replacementStrategy of this {@link DPICustomEntity} instance.
   *
   * @param replacementStrategy The replacementStrategy of this {@link DPICustomEntity}
   */
  public void setReplacementStrategy(@Nonnull final DPIMethodConstant replacementStrategy) {
    this.replacementStrategy = replacementStrategy;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link DPICustomEntity}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link DPICustomEntity} instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException("DPICustomEntity has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link DPICustomEntity} instance including unrecognized
   * properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (regex != null) declaredFields.put("regex", regex);
    if (replacementStrategy != null) declaredFields.put("replacementStrategy", replacementStrategy);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link DPICustomEntity} instance. If the map previously
   * contained a mapping for the key, the old value is replaced by the specified value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final DPICustomEntity dpICustomEntity = (DPICustomEntity) o;
    return Objects.equals(this.cloudSdkCustomFields, dpICustomEntity.cloudSdkCustomFields)
        && Objects.equals(this.regex, dpICustomEntity.regex)
        && Objects.equals(this.replacementStrategy, dpICustomEntity.replacementStrategy);
  }

  @Override
  public int hashCode() {
    return Objects.hash(regex, replacementStrategy, cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class DPICustomEntity {\n");
    sb.append("    regex: ").append(toIndentedString(regex)).append("\n");
    sb.append("    replacementStrategy: ")
        .append(toIndentedString(replacementStrategy))
        .append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create a type-safe, fluent-api builder object to construct a new {@link DPICustomEntity}
   * instance with all required arguments.
   */
  public static Builder create() {
    return (regex) ->
        (replacementStrategy) ->
            new DPICustomEntity().regex(regex).replacementStrategy(replacementStrategy);
  }

  /** Builder helper class. */
  public interface Builder {
    /**
     * Set the regex of this {@link DPICustomEntity} instance.
     *
     * @param regex Regular expression to match the entity
     * @return The DPICustomEntity builder.
     */
    Builder1 regex(@Nonnull final String regex);
  }

  /** Builder helper class. */
  public interface Builder1 {
    /**
     * Set the replacementStrategy of this {@link DPICustomEntity} instance.
     *
     * @param replacementStrategy The replacementStrategy of this {@link DPICustomEntity}
     * @return The DPICustomEntity instance.
     */
    DPICustomEntity replacementStrategy(@Nonnull final DPIMethodConstant replacementStrategy);
  }
}
