/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/** Replaces the entity with a randomly generated value appropriate to its type. */
// CHECKSTYLE:OFF
public class DPIMethodFabricatedData implements DPIStandardEntityReplacementStrategy
// CHECKSTYLE:ON
{
  /** Gets or Sets method */
  public enum MethodEnum {
    /** The FABRICATED_DATA option of this DPIMethodFabricatedData */
    FABRICATED_DATA("fabricated_data"),

    /** The UNKNOWN_DEFAULT_OPEN_API option of this DPIMethodFabricatedData */
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    MethodEnum(String value) {
      this.value = value;
    }

    /**
     * Get the value of the enum
     *
     * @return The enum value
     */
    @JsonValue
    @Nonnull
    public String getValue() {
      return value;
    }

    /**
     * Get the String value of the enum value.
     *
     * @return The enum value as String
     */
    @Override
    @Nonnull
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * Get the enum value from a String value
     *
     * @param value The String value
     * @return The enum value of type DPIMethodFabricatedData
     */
    @JsonCreator
    @Nonnull
    public static MethodEnum fromValue(@Nonnull final String value) {
      for (MethodEnum b : MethodEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  @JsonProperty("method")
  private MethodEnum method;

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for DPIMethodFabricatedData. */
  protected DPIMethodFabricatedData() {}

  /**
   * Set the method of this {@link DPIMethodFabricatedData} instance and return the same instance.
   *
   * @param method The method of this {@link DPIMethodFabricatedData}
   * @return The same instance of this {@link DPIMethodFabricatedData} class
   */
  @Nonnull
  public DPIMethodFabricatedData method(@Nonnull final MethodEnum method) {
    this.method = method;
    return this;
  }

  /**
   * Get method
   *
   * @return method The method of this {@link DPIMethodFabricatedData} instance.
   */
  @Nonnull
  public MethodEnum getMethod() {
    return method;
  }

  /**
   * Set the method of this {@link DPIMethodFabricatedData} instance.
   *
   * @param method The method of this {@link DPIMethodFabricatedData}
   */
  public void setMethod(@Nonnull final MethodEnum method) {
    this.method = method;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link DPIMethodFabricatedData}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link DPIMethodFabricatedData} instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException(
          "DPIMethodFabricatedData has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link DPIMethodFabricatedData} instance including
   * unrecognized properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (method != null) declaredFields.put("method", method);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link DPIMethodFabricatedData} instance. If the map
   * previously contained a mapping for the key, the old value is replaced by the specified value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final DPIMethodFabricatedData dpIMethodFabricatedData = (DPIMethodFabricatedData) o;
    return Objects.equals(this.cloudSdkCustomFields, dpIMethodFabricatedData.cloudSdkCustomFields)
        && Objects.equals(this.method, dpIMethodFabricatedData.method);
  }

  @Override
  public int hashCode() {
    return Objects.hash(method, cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class DPIMethodFabricatedData {\n");
    sb.append("    method: ").append(toIndentedString(method)).append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create a type-safe, fluent-api builder object to construct a new {@link
   * DPIMethodFabricatedData} instance with all required arguments.
   */
  public static Builder create() {
    return (method) -> new DPIMethodFabricatedData().method(method);
  }

  /** Builder helper class. */
  public interface Builder {
    /**
     * Set the method of this {@link DPIMethodFabricatedData} instance.
     *
     * @param method The method of this {@link DPIMethodFabricatedData}
     * @return The DPIMethodFabricatedData instance.
     */
    DPIMethodFabricatedData method(@Nonnull final MethodEnum method);
  }
}
