/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/** Represents an embedding vector returned by embedding endpoint. */
// CHECKSTYLE:OFF
public class EmbeddingResult
// CHECKSTYLE:ON
{
  /** The object type, which is always \&quot;embedding\&quot;. */
  public enum ObjectEnum {
    /** The EMBEDDING option of this EmbeddingResult */
    EMBEDDING("embedding"),

    /** The UNKNOWN_DEFAULT_OPEN_API option of this EmbeddingResult */
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    ObjectEnum(String value) {
      this.value = value;
    }

    /**
     * Get the value of the enum
     *
     * @return The enum value
     */
    @JsonValue
    @Nonnull
    public String getValue() {
      return value;
    }

    /**
     * Get the String value of the enum value.
     *
     * @return The enum value as String
     */
    @Override
    @Nonnull
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * Get the enum value from a String value
     *
     * @param value The String value
     * @return The enum value of type EmbeddingResult
     */
    @JsonCreator
    @Nonnull
    public static ObjectEnum fromValue(@Nonnull final String value) {
      for (ObjectEnum b : ObjectEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  @JsonProperty("object")
  private ObjectEnum _object;

  @JsonProperty("embedding")
  private Embedding embedding;

  @JsonProperty("index")
  private Integer index;

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for EmbeddingResult. */
  protected EmbeddingResult() {}

  /**
   * Set the _object of this {@link EmbeddingResult} instance and return the same instance.
   *
   * @param _object The object type, which is always \&quot;embedding\&quot;.
   * @return The same instance of this {@link EmbeddingResult} class
   */
  @Nonnull
  public EmbeddingResult _object(@Nonnull final ObjectEnum _object) {
    this._object = _object;
    return this;
  }

  /**
   * The object type, which is always \&quot;embedding\&quot;.
   *
   * @return _object The _object of this {@link EmbeddingResult} instance.
   */
  @Nonnull
  public ObjectEnum getObject() {
    return _object;
  }

  /**
   * Set the _object of this {@link EmbeddingResult} instance.
   *
   * @param _object The object type, which is always \&quot;embedding\&quot;.
   */
  public void setObject(@Nonnull final ObjectEnum _object) {
    this._object = _object;
  }

  /**
   * Set the embedding of this {@link EmbeddingResult} instance and return the same instance.
   *
   * @param embedding The embedding of this {@link EmbeddingResult}
   * @return The same instance of this {@link EmbeddingResult} class
   */
  @Nonnull
  public EmbeddingResult embedding(@Nonnull final Embedding embedding) {
    this.embedding = embedding;
    return this;
  }

  /**
   * Get embedding
   *
   * @return embedding The embedding of this {@link EmbeddingResult} instance.
   */
  @Nonnull
  public Embedding getEmbedding() {
    return embedding;
  }

  /**
   * Set the embedding of this {@link EmbeddingResult} instance.
   *
   * @param embedding The embedding of this {@link EmbeddingResult}
   */
  public void setEmbedding(@Nonnull final Embedding embedding) {
    this.embedding = embedding;
  }

  /**
   * Set the index of this {@link EmbeddingResult} instance and return the same instance.
   *
   * @param index The index of the embedding in the list of embeddings.
   * @return The same instance of this {@link EmbeddingResult} class
   */
  @Nonnull
  public EmbeddingResult index(@Nonnull final Integer index) {
    this.index = index;
    return this;
  }

  /**
   * The index of the embedding in the list of embeddings.
   *
   * @return index The index of this {@link EmbeddingResult} instance.
   */
  @Nonnull
  public Integer getIndex() {
    return index;
  }

  /**
   * Set the index of this {@link EmbeddingResult} instance.
   *
   * @param index The index of the embedding in the list of embeddings.
   */
  public void setIndex(@Nonnull final Integer index) {
    this.index = index;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link EmbeddingResult}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link EmbeddingResult} instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException("EmbeddingResult has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link EmbeddingResult} instance including unrecognized
   * properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (_object != null) declaredFields.put("_object", _object);
    if (embedding != null) declaredFields.put("embedding", embedding);
    if (index != null) declaredFields.put("index", index);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link EmbeddingResult} instance. If the map previously
   * contained a mapping for the key, the old value is replaced by the specified value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final EmbeddingResult embeddingResult = (EmbeddingResult) o;
    return Objects.equals(this.cloudSdkCustomFields, embeddingResult.cloudSdkCustomFields)
        && Objects.equals(this._object, embeddingResult._object)
        && Objects.equals(this.embedding, embeddingResult.embedding)
        && Objects.equals(this.index, embeddingResult.index);
  }

  @Override
  public int hashCode() {
    return Objects.hash(_object, embedding, index, cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class EmbeddingResult {\n");
    sb.append("    _object: ").append(toIndentedString(_object)).append("\n");
    sb.append("    embedding: ").append(toIndentedString(embedding)).append("\n");
    sb.append("    index: ").append(toIndentedString(index)).append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create a type-safe, fluent-api builder object to construct a new {@link EmbeddingResult}
   * instance with all required arguments.
   */
  public static Builder create() {
    return (_object) ->
        (embedding) ->
            (index) -> new EmbeddingResult()._object(_object).embedding(embedding).index(index);
  }

  /** Builder helper class. */
  public interface Builder {
    /**
     * Set the _object of this {@link EmbeddingResult} instance.
     *
     * @param _object The object type, which is always \&quot;embedding\&quot;.
     * @return The EmbeddingResult builder.
     */
    Builder1 _object(@Nonnull final ObjectEnum _object);
  }

  /** Builder helper class. */
  public interface Builder1 {
    /**
     * Set the embedding of this {@link EmbeddingResult} instance.
     *
     * @param embedding The embedding of this {@link EmbeddingResult}
     * @return The EmbeddingResult builder.
     */
    Builder2 embedding(@Nonnull final Embedding embedding);
  }

  /** Builder helper class. */
  public interface Builder2 {
    /**
     * Set the index of this {@link EmbeddingResult} instance.
     *
     * @param index The index of the embedding in the list of embeddings.
     * @return The EmbeddingResult instance.
     */
    EmbeddingResult index(@Nonnull final Integer index);
  }
}
