/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import java.util.List;
import javax.annotation.Nonnull;

/** Text input for which embeddings need to be generated */
public interface EmbeddingsInputText {
  /** Helper class to create a String that implements {@link EmbeddingsInputText}. */
  record InnerString(@com.fasterxml.jackson.annotation.JsonValue @Nonnull String value)
      implements EmbeddingsInputText {}

  /**
   * Creator to enable deserialization of a String.
   *
   * @param val the value to use
   * @return a new instance of {@link InnerString}.
   */
  @com.fasterxml.jackson.annotation.JsonCreator
  @Nonnull
  static InnerString create(@Nonnull final String val) {
    return new InnerString(val);
  }

  /** Helper class to create a list of String that implements {@link EmbeddingsInputText}. */
  record InnerStrings(@com.fasterxml.jackson.annotation.JsonValue @Nonnull List<String> values)
      implements EmbeddingsInputText {}

  /**
   * Creator to enable deserialization of a list of String.
   *
   * @param val the value to use
   * @return a new instance of {@link InnerStrings}.
   */
  @com.fasterxml.jackson.annotation.JsonCreator
  @Nonnull
  static InnerStrings create(@Nonnull final List<String> val) {
    return new InnerStrings(val);
  }
}
