/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/** EmbeddingsModelDetails */
// CHECKSTYLE:OFF
public class EmbeddingsModelDetails
// CHECKSTYLE:ON
{
  @JsonProperty("name")
  private String name;

  @JsonProperty("version")
  private String version = "latest";

  @JsonProperty("params")
  private EmbeddingsModelParams params;

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for EmbeddingsModelDetails. */
  protected EmbeddingsModelDetails() {}

  /**
   * Set the name of this {@link EmbeddingsModelDetails} instance and return the same instance.
   *
   * @param name The name of this {@link EmbeddingsModelDetails}
   * @return The same instance of this {@link EmbeddingsModelDetails} class
   */
  @Nonnull
  public EmbeddingsModelDetails name(@Nonnull final String name) {
    this.name = name;
    return this;
  }

  /**
   * Get name
   *
   * @return name The name of this {@link EmbeddingsModelDetails} instance.
   */
  @Nonnull
  public String getName() {
    return name;
  }

  /**
   * Set the name of this {@link EmbeddingsModelDetails} instance.
   *
   * @param name The name of this {@link EmbeddingsModelDetails}
   */
  public void setName(@Nonnull final String name) {
    this.name = name;
  }

  /**
   * Set the version of this {@link EmbeddingsModelDetails} instance and return the same instance.
   *
   * @param version The version of this {@link EmbeddingsModelDetails}
   * @return The same instance of this {@link EmbeddingsModelDetails} class
   */
  @Nonnull
  public EmbeddingsModelDetails version(@Nullable final String version) {
    this.version = version;
    return this;
  }

  /**
   * Get version
   *
   * @return version The version of this {@link EmbeddingsModelDetails} instance.
   */
  @Nonnull
  public String getVersion() {
    return version;
  }

  /**
   * Set the version of this {@link EmbeddingsModelDetails} instance.
   *
   * @param version The version of this {@link EmbeddingsModelDetails}
   */
  public void setVersion(@Nullable final String version) {
    this.version = version;
  }

  /**
   * Set the params of this {@link EmbeddingsModelDetails} instance and return the same instance.
   *
   * @param params The params of this {@link EmbeddingsModelDetails}
   * @return The same instance of this {@link EmbeddingsModelDetails} class
   */
  @Nonnull
  public EmbeddingsModelDetails params(@Nullable final EmbeddingsModelParams params) {
    this.params = params;
    return this;
  }

  /**
   * Get params
   *
   * @return params The params of this {@link EmbeddingsModelDetails} instance.
   */
  @Nonnull
  public EmbeddingsModelParams getParams() {
    return params;
  }

  /**
   * Set the params of this {@link EmbeddingsModelDetails} instance.
   *
   * @param params The params of this {@link EmbeddingsModelDetails}
   */
  public void setParams(@Nullable final EmbeddingsModelParams params) {
    this.params = params;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link EmbeddingsModelDetails}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link EmbeddingsModelDetails} instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException(
          "EmbeddingsModelDetails has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link EmbeddingsModelDetails} instance including
   * unrecognized properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (name != null) declaredFields.put("name", name);
    if (version != null) declaredFields.put("version", version);
    if (params != null) declaredFields.put("params", params);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link EmbeddingsModelDetails} instance. If the map
   * previously contained a mapping for the key, the old value is replaced by the specified value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final EmbeddingsModelDetails embeddingsModelDetails = (EmbeddingsModelDetails) o;
    return Objects.equals(this.cloudSdkCustomFields, embeddingsModelDetails.cloudSdkCustomFields)
        && Objects.equals(this.name, embeddingsModelDetails.name)
        && Objects.equals(this.version, embeddingsModelDetails.version)
        && Objects.equals(this.params, embeddingsModelDetails.params);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, version, params, cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class EmbeddingsModelDetails {\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    params: ").append(toIndentedString(params)).append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create a type-safe, fluent-api builder object to construct a new {@link EmbeddingsModelDetails}
   * instance with all required arguments.
   */
  public static Builder create() {
    return (name) -> new EmbeddingsModelDetails().name(name);
  }

  /** Builder helper class. */
  public interface Builder {
    /**
     * Set the name of this {@link EmbeddingsModelDetails} instance.
     *
     * @param name The name of this {@link EmbeddingsModelDetails}
     * @return The EmbeddingsModelDetails instance.
     */
    EmbeddingsModelDetails name(@Nonnull final String name);
  }
}
