/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/**
 * Additional parameters for generating input&#39;s embeddings. Default values are used for
 * mandatory parameters.
 */
// CHECKSTYLE:OFF
public class EmbeddingsModelParams
// CHECKSTYLE:ON
{
  @JsonProperty("dimensions")
  private Integer dimensions;

  /** OpenAI&#39;s spec allows for &#39;float&#39; and &#39;base64&#39; encoding formats. */
  public enum EncodingFormatEnum {
    /** The FLOAT option of this EmbeddingsModelParams */
    FLOAT("float"),

    /** The BASE64 option of this EmbeddingsModelParams */
    BASE64("base64"),

    /** The BINARY option of this EmbeddingsModelParams */
    BINARY("binary"),

    /** The UNKNOWN_DEFAULT_OPEN_API option of this EmbeddingsModelParams */
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    EncodingFormatEnum(String value) {
      this.value = value;
    }

    /**
     * Get the value of the enum
     *
     * @return The enum value
     */
    @JsonValue
    @Nonnull
    public String getValue() {
      return value;
    }

    /**
     * Get the String value of the enum value.
     *
     * @return The enum value as String
     */
    @Override
    @Nonnull
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * Get the enum value from a String value
     *
     * @param value The String value
     * @return The enum value of type EmbeddingsModelParams
     */
    @JsonCreator
    @Nonnull
    public static EncodingFormatEnum fromValue(@Nonnull final String value) {
      for (EncodingFormatEnum b : EncodingFormatEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  @JsonProperty("encoding_format")
  private EncodingFormatEnum encodingFormat;

  @JsonProperty("normalize")
  private Boolean normalize;

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for EmbeddingsModelParams. */
  protected EmbeddingsModelParams() {}

  /**
   * Set the dimensions of this {@link EmbeddingsModelParams} instance and return the same instance.
   *
   * @param dimensions The number of dimensions the resulting output embeddings should have.
   * @return The same instance of this {@link EmbeddingsModelParams} class
   */
  @Nonnull
  public EmbeddingsModelParams dimensions(@Nullable final Integer dimensions) {
    this.dimensions = dimensions;
    return this;
  }

  /**
   * The number of dimensions the resulting output embeddings should have.
   *
   * @return dimensions The dimensions of this {@link EmbeddingsModelParams} instance.
   */
  @Nonnull
  public Integer getDimensions() {
    return dimensions;
  }

  /**
   * Set the dimensions of this {@link EmbeddingsModelParams} instance.
   *
   * @param dimensions The number of dimensions the resulting output embeddings should have.
   */
  public void setDimensions(@Nullable final Integer dimensions) {
    this.dimensions = dimensions;
  }

  /**
   * Set the encodingFormat of this {@link EmbeddingsModelParams} instance and return the same
   * instance.
   *
   * @param encodingFormat OpenAI&#39;s spec allows for &#39;float&#39; and &#39;base64&#39;
   *     encoding formats.
   * @return The same instance of this {@link EmbeddingsModelParams} class
   */
  @Nonnull
  public EmbeddingsModelParams encodingFormat(@Nullable final EncodingFormatEnum encodingFormat) {
    this.encodingFormat = encodingFormat;
    return this;
  }

  /**
   * OpenAI&#39;s spec allows for &#39;float&#39; and &#39;base64&#39; encoding formats.
   *
   * @return encodingFormat The encodingFormat of this {@link EmbeddingsModelParams} instance.
   */
  @Nonnull
  public EncodingFormatEnum getEncodingFormat() {
    return encodingFormat;
  }

  /**
   * Set the encodingFormat of this {@link EmbeddingsModelParams} instance.
   *
   * @param encodingFormat OpenAI&#39;s spec allows for &#39;float&#39; and &#39;base64&#39;
   *     encoding formats.
   */
  public void setEncodingFormat(@Nullable final EncodingFormatEnum encodingFormat) {
    this.encodingFormat = encodingFormat;
  }

  /**
   * Set the normalize of this {@link EmbeddingsModelParams} instance and return the same instance.
   *
   * @param normalize The normalize of this {@link EmbeddingsModelParams}
   * @return The same instance of this {@link EmbeddingsModelParams} class
   */
  @Nonnull
  public EmbeddingsModelParams normalize(@Nullable final Boolean normalize) {
    this.normalize = normalize;
    return this;
  }

  /**
   * Get normalize
   *
   * @return normalize The normalize of this {@link EmbeddingsModelParams} instance.
   */
  @Nonnull
  public Boolean isNormalize() {
    return normalize;
  }

  /**
   * Set the normalize of this {@link EmbeddingsModelParams} instance.
   *
   * @param normalize The normalize of this {@link EmbeddingsModelParams}
   */
  public void setNormalize(@Nullable final Boolean normalize) {
    this.normalize = normalize;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link EmbeddingsModelParams}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link EmbeddingsModelParams} instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException(
          "EmbeddingsModelParams has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link EmbeddingsModelParams} instance including
   * unrecognized properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (dimensions != null) declaredFields.put("dimensions", dimensions);
    if (encodingFormat != null) declaredFields.put("encodingFormat", encodingFormat);
    if (normalize != null) declaredFields.put("normalize", normalize);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link EmbeddingsModelParams} instance. If the map
   * previously contained a mapping for the key, the old value is replaced by the specified value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final EmbeddingsModelParams embeddingsModelParams = (EmbeddingsModelParams) o;
    return Objects.equals(this.cloudSdkCustomFields, embeddingsModelParams.cloudSdkCustomFields)
        && Objects.equals(this.dimensions, embeddingsModelParams.dimensions)
        && Objects.equals(this.encodingFormat, embeddingsModelParams.encodingFormat)
        && Objects.equals(this.normalize, embeddingsModelParams.normalize);
  }

  @Override
  public int hashCode() {
    return Objects.hash(dimensions, encodingFormat, normalize, cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class EmbeddingsModelParams {\n");
    sb.append("    dimensions: ").append(toIndentedString(dimensions)).append("\n");
    sb.append("    encodingFormat: ").append(toIndentedString(encodingFormat)).append("\n");
    sb.append("    normalize: ").append(toIndentedString(normalize)).append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /** Create a new {@link EmbeddingsModelParams} instance. No arguments are required. */
  public static EmbeddingsModelParams create() {
    return new EmbeddingsModelParams();
  }
}
