/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/** EmbeddingsPostRequest */
// CHECKSTYLE:OFF
public class EmbeddingsPostRequest
// CHECKSTYLE:ON
{
  @JsonProperty("config")
  private EmbeddingsOrchestrationConfig config;

  @JsonProperty("input")
  private EmbeddingsInput input;

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for EmbeddingsPostRequest. */
  protected EmbeddingsPostRequest() {}

  /**
   * Set the config of this {@link EmbeddingsPostRequest} instance and return the same instance.
   *
   * @param config The config of this {@link EmbeddingsPostRequest}
   * @return The same instance of this {@link EmbeddingsPostRequest} class
   */
  @Nonnull
  public EmbeddingsPostRequest config(@Nonnull final EmbeddingsOrchestrationConfig config) {
    this.config = config;
    return this;
  }

  /**
   * Get config
   *
   * @return config The config of this {@link EmbeddingsPostRequest} instance.
   */
  @Nonnull
  public EmbeddingsOrchestrationConfig getConfig() {
    return config;
  }

  /**
   * Set the config of this {@link EmbeddingsPostRequest} instance.
   *
   * @param config The config of this {@link EmbeddingsPostRequest}
   */
  public void setConfig(@Nonnull final EmbeddingsOrchestrationConfig config) {
    this.config = config;
  }

  /**
   * Set the input of this {@link EmbeddingsPostRequest} instance and return the same instance.
   *
   * @param input The input of this {@link EmbeddingsPostRequest}
   * @return The same instance of this {@link EmbeddingsPostRequest} class
   */
  @Nonnull
  public EmbeddingsPostRequest input(@Nonnull final EmbeddingsInput input) {
    this.input = input;
    return this;
  }

  /**
   * Get input
   *
   * @return input The input of this {@link EmbeddingsPostRequest} instance.
   */
  @Nonnull
  public EmbeddingsInput getInput() {
    return input;
  }

  /**
   * Set the input of this {@link EmbeddingsPostRequest} instance.
   *
   * @param input The input of this {@link EmbeddingsPostRequest}
   */
  public void setInput(@Nonnull final EmbeddingsInput input) {
    this.input = input;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link EmbeddingsPostRequest}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link EmbeddingsPostRequest} instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException(
          "EmbeddingsPostRequest has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link EmbeddingsPostRequest} instance including
   * unrecognized properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (config != null) declaredFields.put("config", config);
    if (input != null) declaredFields.put("input", input);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link EmbeddingsPostRequest} instance. If the map
   * previously contained a mapping for the key, the old value is replaced by the specified value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final EmbeddingsPostRequest embeddingsPostRequest = (EmbeddingsPostRequest) o;
    return Objects.equals(this.cloudSdkCustomFields, embeddingsPostRequest.cloudSdkCustomFields)
        && Objects.equals(this.config, embeddingsPostRequest.config)
        && Objects.equals(this.input, embeddingsPostRequest.input);
  }

  @Override
  public int hashCode() {
    return Objects.hash(config, input, cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class EmbeddingsPostRequest {\n");
    sb.append("    config: ").append(toIndentedString(config)).append("\n");
    sb.append("    input: ").append(toIndentedString(input)).append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create a type-safe, fluent-api builder object to construct a new {@link EmbeddingsPostRequest}
   * instance with all required arguments.
   */
  public static Builder create() {
    return (config) -> (input) -> new EmbeddingsPostRequest().config(config).input(input);
  }

  /** Builder helper class. */
  public interface Builder {
    /**
     * Set the config of this {@link EmbeddingsPostRequest} instance.
     *
     * @param config The config of this {@link EmbeddingsPostRequest}
     * @return The EmbeddingsPostRequest builder.
     */
    Builder1 config(@Nonnull final EmbeddingsOrchestrationConfig config);
  }

  /** Builder helper class. */
  public interface Builder1 {
    /**
     * Set the input of this {@link EmbeddingsPostRequest} instance.
     *
     * @param input The input of this {@link EmbeddingsPostRequest}
     * @return The EmbeddingsPostRequest instance.
     */
    EmbeddingsPostRequest input(@Nonnull final EmbeddingsInput input);
  }
}
