/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/** EmbeddingsPostResponse */
// CHECKSTYLE:OFF
public class EmbeddingsPostResponse
// CHECKSTYLE:ON
{
  @JsonProperty("request_id")
  private String requestId;

  @JsonProperty("intermediate_results")
  private ModuleResultsBase intermediateResults;

  @JsonProperty("final_result")
  private EmbeddingsResponse finalResult;

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for EmbeddingsPostResponse. */
  protected EmbeddingsPostResponse() {}

  /**
   * Set the requestId of this {@link EmbeddingsPostResponse} instance and return the same instance.
   *
   * @param requestId The requestId of this {@link EmbeddingsPostResponse}
   * @return The same instance of this {@link EmbeddingsPostResponse} class
   */
  @Nonnull
  public EmbeddingsPostResponse requestId(@Nonnull final String requestId) {
    this.requestId = requestId;
    return this;
  }

  /**
   * Get requestId
   *
   * @return requestId The requestId of this {@link EmbeddingsPostResponse} instance.
   */
  @Nonnull
  public String getRequestId() {
    return requestId;
  }

  /**
   * Set the requestId of this {@link EmbeddingsPostResponse} instance.
   *
   * @param requestId The requestId of this {@link EmbeddingsPostResponse}
   */
  public void setRequestId(@Nonnull final String requestId) {
    this.requestId = requestId;
  }

  /**
   * Set the intermediateResults of this {@link EmbeddingsPostResponse} instance and return the same
   * instance.
   *
   * @param intermediateResults The intermediateResults of this {@link EmbeddingsPostResponse}
   * @return The same instance of this {@link EmbeddingsPostResponse} class
   */
  @Nonnull
  public EmbeddingsPostResponse intermediateResults(
      @Nullable final ModuleResultsBase intermediateResults) {
    this.intermediateResults = intermediateResults;
    return this;
  }

  /**
   * Get intermediateResults
   *
   * @return intermediateResults The intermediateResults of this {@link EmbeddingsPostResponse}
   *     instance.
   */
  @Nonnull
  public ModuleResultsBase getIntermediateResults() {
    return intermediateResults;
  }

  /**
   * Set the intermediateResults of this {@link EmbeddingsPostResponse} instance.
   *
   * @param intermediateResults The intermediateResults of this {@link EmbeddingsPostResponse}
   */
  public void setIntermediateResults(@Nullable final ModuleResultsBase intermediateResults) {
    this.intermediateResults = intermediateResults;
  }

  /**
   * Set the finalResult of this {@link EmbeddingsPostResponse} instance and return the same
   * instance.
   *
   * @param finalResult The finalResult of this {@link EmbeddingsPostResponse}
   * @return The same instance of this {@link EmbeddingsPostResponse} class
   */
  @Nonnull
  public EmbeddingsPostResponse finalResult(@Nullable final EmbeddingsResponse finalResult) {
    this.finalResult = finalResult;
    return this;
  }

  /**
   * Get finalResult
   *
   * @return finalResult The finalResult of this {@link EmbeddingsPostResponse} instance.
   */
  @Nonnull
  public EmbeddingsResponse getFinalResult() {
    return finalResult;
  }

  /**
   * Set the finalResult of this {@link EmbeddingsPostResponse} instance.
   *
   * @param finalResult The finalResult of this {@link EmbeddingsPostResponse}
   */
  public void setFinalResult(@Nullable final EmbeddingsResponse finalResult) {
    this.finalResult = finalResult;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link EmbeddingsPostResponse}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link EmbeddingsPostResponse} instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException(
          "EmbeddingsPostResponse has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link EmbeddingsPostResponse} instance including
   * unrecognized properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (requestId != null) declaredFields.put("requestId", requestId);
    if (intermediateResults != null) declaredFields.put("intermediateResults", intermediateResults);
    if (finalResult != null) declaredFields.put("finalResult", finalResult);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link EmbeddingsPostResponse} instance. If the map
   * previously contained a mapping for the key, the old value is replaced by the specified value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final EmbeddingsPostResponse embeddingsPostResponse = (EmbeddingsPostResponse) o;
    return Objects.equals(this.cloudSdkCustomFields, embeddingsPostResponse.cloudSdkCustomFields)
        && Objects.equals(this.requestId, embeddingsPostResponse.requestId)
        && Objects.equals(this.intermediateResults, embeddingsPostResponse.intermediateResults)
        && Objects.equals(this.finalResult, embeddingsPostResponse.finalResult);
  }

  @Override
  public int hashCode() {
    return Objects.hash(requestId, intermediateResults, finalResult, cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class EmbeddingsPostResponse {\n");
    sb.append("    requestId: ").append(toIndentedString(requestId)).append("\n");
    sb.append("    intermediateResults: ")
        .append(toIndentedString(intermediateResults))
        .append("\n");
    sb.append("    finalResult: ").append(toIndentedString(finalResult)).append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create a type-safe, fluent-api builder object to construct a new {@link EmbeddingsPostResponse}
   * instance with all required arguments.
   */
  public static Builder create() {
    return (requestId) -> new EmbeddingsPostResponse().requestId(requestId);
  }

  /** Builder helper class. */
  public interface Builder {
    /**
     * Set the requestId of this {@link EmbeddingsPostResponse} instance.
     *
     * @param requestId The requestId of this {@link EmbeddingsPostResponse}
     * @return The EmbeddingsPostResponse instance.
     */
    EmbeddingsPostResponse requestId(@Nonnull final String requestId);
  }
}
