/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/** The response from request to embedding model following OpenAI specification. */
// CHECKSTYLE:OFF
public class EmbeddingsResponse
// CHECKSTYLE:ON
{
  /** The object type, which is always \&quot;list\&quot;. */
  public enum ObjectEnum {
    /** The LIST option of this EmbeddingsResponse */
    LIST("list"),

    /** The UNKNOWN_DEFAULT_OPEN_API option of this EmbeddingsResponse */
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    ObjectEnum(String value) {
      this.value = value;
    }

    /**
     * Get the value of the enum
     *
     * @return The enum value
     */
    @JsonValue
    @Nonnull
    public String getValue() {
      return value;
    }

    /**
     * Get the String value of the enum value.
     *
     * @return The enum value as String
     */
    @Override
    @Nonnull
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * Get the enum value from a String value
     *
     * @param value The String value
     * @return The enum value of type EmbeddingsResponse
     */
    @JsonCreator
    @Nonnull
    public static ObjectEnum fromValue(@Nonnull final String value) {
      for (ObjectEnum b : ObjectEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  @JsonProperty("object")
  private ObjectEnum _object;

  @JsonProperty("data")
  private List<EmbeddingResult> data = new ArrayList<>();

  @JsonProperty("model")
  private String model;

  @JsonProperty("usage")
  private EmbeddingsUsage usage;

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for EmbeddingsResponse. */
  protected EmbeddingsResponse() {}

  /**
   * Set the _object of this {@link EmbeddingsResponse} instance and return the same instance.
   *
   * @param _object The object type, which is always \&quot;list\&quot;.
   * @return The same instance of this {@link EmbeddingsResponse} class
   */
  @Nonnull
  public EmbeddingsResponse _object(@Nonnull final ObjectEnum _object) {
    this._object = _object;
    return this;
  }

  /**
   * The object type, which is always \&quot;list\&quot;.
   *
   * @return _object The _object of this {@link EmbeddingsResponse} instance.
   */
  @Nonnull
  public ObjectEnum getObject() {
    return _object;
  }

  /**
   * Set the _object of this {@link EmbeddingsResponse} instance.
   *
   * @param _object The object type, which is always \&quot;list\&quot;.
   */
  public void setObject(@Nonnull final ObjectEnum _object) {
    this._object = _object;
  }

  /**
   * Set the data of this {@link EmbeddingsResponse} instance and return the same instance.
   *
   * @param data The list of embeddings generated by the model.
   * @return The same instance of this {@link EmbeddingsResponse} class
   */
  @Nonnull
  public EmbeddingsResponse data(@Nonnull final List<EmbeddingResult> data) {
    this.data = data;
    return this;
  }

  /**
   * Add one data instance to this {@link EmbeddingsResponse}.
   *
   * @param dataItem The data that should be added
   * @return The same instance of type {@link EmbeddingsResponse}
   */
  @Nonnull
  public EmbeddingsResponse addDataItem(@Nonnull final EmbeddingResult dataItem) {
    if (this.data == null) {
      this.data = new ArrayList<>();
    }
    this.data.add(dataItem);
    return this;
  }

  /**
   * The list of embeddings generated by the model.
   *
   * @return data The data of this {@link EmbeddingsResponse} instance.
   */
  @Nonnull
  public List<EmbeddingResult> getData() {
    return data;
  }

  /**
   * Set the data of this {@link EmbeddingsResponse} instance.
   *
   * @param data The list of embeddings generated by the model.
   */
  public void setData(@Nonnull final List<EmbeddingResult> data) {
    this.data = data;
  }

  /**
   * Set the model of this {@link EmbeddingsResponse} instance and return the same instance.
   *
   * @param model The name of the model used to generate the embedding.
   * @return The same instance of this {@link EmbeddingsResponse} class
   */
  @Nonnull
  public EmbeddingsResponse model(@Nonnull final String model) {
    this.model = model;
    return this;
  }

  /**
   * The name of the model used to generate the embedding.
   *
   * @return model The model of this {@link EmbeddingsResponse} instance.
   */
  @Nonnull
  public String getModel() {
    return model;
  }

  /**
   * Set the model of this {@link EmbeddingsResponse} instance.
   *
   * @param model The name of the model used to generate the embedding.
   */
  public void setModel(@Nonnull final String model) {
    this.model = model;
  }

  /**
   * Set the usage of this {@link EmbeddingsResponse} instance and return the same instance.
   *
   * @param usage The usage of this {@link EmbeddingsResponse}
   * @return The same instance of this {@link EmbeddingsResponse} class
   */
  @Nonnull
  public EmbeddingsResponse usage(@Nonnull final EmbeddingsUsage usage) {
    this.usage = usage;
    return this;
  }

  /**
   * Get usage
   *
   * @return usage The usage of this {@link EmbeddingsResponse} instance.
   */
  @Nonnull
  public EmbeddingsUsage getUsage() {
    return usage;
  }

  /**
   * Set the usage of this {@link EmbeddingsResponse} instance.
   *
   * @param usage The usage of this {@link EmbeddingsResponse}
   */
  public void setUsage(@Nonnull final EmbeddingsUsage usage) {
    this.usage = usage;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link EmbeddingsResponse}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link EmbeddingsResponse} instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException("EmbeddingsResponse has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link EmbeddingsResponse} instance including
   * unrecognized properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (_object != null) declaredFields.put("_object", _object);
    if (data != null) declaredFields.put("data", data);
    if (model != null) declaredFields.put("model", model);
    if (usage != null) declaredFields.put("usage", usage);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link EmbeddingsResponse} instance. If the map
   * previously contained a mapping for the key, the old value is replaced by the specified value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final EmbeddingsResponse embeddingsResponse = (EmbeddingsResponse) o;
    return Objects.equals(this.cloudSdkCustomFields, embeddingsResponse.cloudSdkCustomFields)
        && Objects.equals(this._object, embeddingsResponse._object)
        && Objects.equals(this.data, embeddingsResponse.data)
        && Objects.equals(this.model, embeddingsResponse.model)
        && Objects.equals(this.usage, embeddingsResponse.usage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(_object, data, model, usage, cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class EmbeddingsResponse {\n");
    sb.append("    _object: ").append(toIndentedString(_object)).append("\n");
    sb.append("    data: ").append(toIndentedString(data)).append("\n");
    sb.append("    model: ").append(toIndentedString(model)).append("\n");
    sb.append("    usage: ").append(toIndentedString(usage)).append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create a type-safe, fluent-api builder object to construct a new {@link EmbeddingsResponse}
   * instance with all required arguments.
   */
  public static Builder create() {
    return (_object) ->
        (data) ->
            (model) ->
                (usage) ->
                    new EmbeddingsResponse()._object(_object).data(data).model(model).usage(usage);
  }

  /** Builder helper class. */
  public interface Builder {
    /**
     * Set the _object of this {@link EmbeddingsResponse} instance.
     *
     * @param _object The object type, which is always \&quot;list\&quot;.
     * @return The EmbeddingsResponse builder.
     */
    Builder1 _object(@Nonnull final ObjectEnum _object);
  }

  /** Builder helper class. */
  public interface Builder1 {
    /**
     * Set the data of this {@link EmbeddingsResponse} instance.
     *
     * @param data The list of embeddings generated by the model.
     * @return The EmbeddingsResponse builder.
     */
    Builder2 data(@Nonnull final List<EmbeddingResult> data);

    /**
     * Set the data of this {@link EmbeddingsResponse} instance.
     *
     * @param data The list of embeddings generated by the model.
     * @return The EmbeddingsResponse builder.
     */
    default Builder2 data(@Nonnull final EmbeddingResult... data) {
      return data(Arrays.asList(data));
    }
  }

  /** Builder helper class. */
  public interface Builder2 {
    /**
     * Set the model of this {@link EmbeddingsResponse} instance.
     *
     * @param model The name of the model used to generate the embedding.
     * @return The EmbeddingsResponse builder.
     */
    Builder3 model(@Nonnull final String model);
  }

  /** Builder helper class. */
  public interface Builder3 {
    /**
     * Set the usage of this {@link EmbeddingsResponse} instance.
     *
     * @param usage The usage of this {@link EmbeddingsResponse}
     * @return The EmbeddingsResponse instance.
     */
    EmbeddingsResponse usage(@Nonnull final EmbeddingsUsage usage);
  }
}
