/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/** The usage information for the request. */
// CHECKSTYLE:OFF
public class EmbeddingsUsage
// CHECKSTYLE:ON
{
  @JsonProperty("prompt_tokens")
  private Integer promptTokens;

  @JsonProperty("total_tokens")
  private Integer totalTokens;

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for EmbeddingsUsage. */
  protected EmbeddingsUsage() {}

  /**
   * Set the promptTokens of this {@link EmbeddingsUsage} instance and return the same instance.
   *
   * @param promptTokens The number of tokens used by the prompt.
   * @return The same instance of this {@link EmbeddingsUsage} class
   */
  @Nonnull
  public EmbeddingsUsage promptTokens(@Nonnull final Integer promptTokens) {
    this.promptTokens = promptTokens;
    return this;
  }

  /**
   * The number of tokens used by the prompt.
   *
   * @return promptTokens The promptTokens of this {@link EmbeddingsUsage} instance.
   */
  @Nonnull
  public Integer getPromptTokens() {
    return promptTokens;
  }

  /**
   * Set the promptTokens of this {@link EmbeddingsUsage} instance.
   *
   * @param promptTokens The number of tokens used by the prompt.
   */
  public void setPromptTokens(@Nonnull final Integer promptTokens) {
    this.promptTokens = promptTokens;
  }

  /**
   * Set the totalTokens of this {@link EmbeddingsUsage} instance and return the same instance.
   *
   * @param totalTokens The total number of tokens used by the request.
   * @return The same instance of this {@link EmbeddingsUsage} class
   */
  @Nonnull
  public EmbeddingsUsage totalTokens(@Nonnull final Integer totalTokens) {
    this.totalTokens = totalTokens;
    return this;
  }

  /**
   * The total number of tokens used by the request.
   *
   * @return totalTokens The totalTokens of this {@link EmbeddingsUsage} instance.
   */
  @Nonnull
  public Integer getTotalTokens() {
    return totalTokens;
  }

  /**
   * Set the totalTokens of this {@link EmbeddingsUsage} instance.
   *
   * @param totalTokens The total number of tokens used by the request.
   */
  public void setTotalTokens(@Nonnull final Integer totalTokens) {
    this.totalTokens = totalTokens;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link EmbeddingsUsage}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link EmbeddingsUsage} instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException("EmbeddingsUsage has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link EmbeddingsUsage} instance including unrecognized
   * properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (promptTokens != null) declaredFields.put("promptTokens", promptTokens);
    if (totalTokens != null) declaredFields.put("totalTokens", totalTokens);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link EmbeddingsUsage} instance. If the map previously
   * contained a mapping for the key, the old value is replaced by the specified value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final EmbeddingsUsage embeddingsUsage = (EmbeddingsUsage) o;
    return Objects.equals(this.cloudSdkCustomFields, embeddingsUsage.cloudSdkCustomFields)
        && Objects.equals(this.promptTokens, embeddingsUsage.promptTokens)
        && Objects.equals(this.totalTokens, embeddingsUsage.totalTokens);
  }

  @Override
  public int hashCode() {
    return Objects.hash(promptTokens, totalTokens, cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class EmbeddingsUsage {\n");
    sb.append("    promptTokens: ").append(toIndentedString(promptTokens)).append("\n");
    sb.append("    totalTokens: ").append(toIndentedString(totalTokens)).append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create a type-safe, fluent-api builder object to construct a new {@link EmbeddingsUsage}
   * instance with all required arguments.
   */
  public static Builder create() {
    return (promptTokens) ->
        (totalTokens) -> new EmbeddingsUsage().promptTokens(promptTokens).totalTokens(totalTokens);
  }

  /** Builder helper class. */
  public interface Builder {
    /**
     * Set the promptTokens of this {@link EmbeddingsUsage} instance.
     *
     * @param promptTokens The number of tokens used by the prompt.
     * @return The EmbeddingsUsage builder.
     */
    Builder1 promptTokens(@Nonnull final Integer promptTokens);
  }

  /** Builder helper class. */
  public interface Builder1 {
    /**
     * Set the totalTokens of this {@link EmbeddingsUsage} instance.
     *
     * @param totalTokens The total number of tokens used by the request.
     * @return The EmbeddingsUsage instance.
     */
    EmbeddingsUsage totalTokens(@Nonnull final Integer totalTokens);
  }
}
