/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/** ImageContentUrl */
// CHECKSTYLE:OFF
public class ImageContentUrl
// CHECKSTYLE:ON
{
  @JsonProperty("url")
  private String url;

  @JsonProperty("detail")
  private String detail = "auto";

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for ImageContentUrl. */
  protected ImageContentUrl() {}

  /**
   * Set the url of this {@link ImageContentUrl} instance and return the same instance.
   *
   * @param url The url of this {@link ImageContentUrl}
   * @return The same instance of this {@link ImageContentUrl} class
   */
  @Nonnull
  public ImageContentUrl url(@Nonnull final String url) {
    this.url = url;
    return this;
  }

  /**
   * Get url
   *
   * @return url The url of this {@link ImageContentUrl} instance.
   */
  @Nonnull
  public String getUrl() {
    return url;
  }

  /**
   * Set the url of this {@link ImageContentUrl} instance.
   *
   * @param url The url of this {@link ImageContentUrl}
   */
  public void setUrl(@Nonnull final String url) {
    this.url = url;
  }

  /**
   * Set the detail of this {@link ImageContentUrl} instance and return the same instance.
   *
   * @param detail The detail of this {@link ImageContentUrl}
   * @return The same instance of this {@link ImageContentUrl} class
   */
  @Nonnull
  public ImageContentUrl detail(@Nullable final String detail) {
    this.detail = detail;
    return this;
  }

  /**
   * Get detail
   *
   * @return detail The detail of this {@link ImageContentUrl} instance.
   */
  @Nonnull
  public String getDetail() {
    return detail;
  }

  /**
   * Set the detail of this {@link ImageContentUrl} instance.
   *
   * @param detail The detail of this {@link ImageContentUrl}
   */
  public void setDetail(@Nullable final String detail) {
    this.detail = detail;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link ImageContentUrl}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link ImageContentUrl} instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException("ImageContentUrl has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link ImageContentUrl} instance including unrecognized
   * properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (url != null) declaredFields.put("url", url);
    if (detail != null) declaredFields.put("detail", detail);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link ImageContentUrl} instance. If the map previously
   * contained a mapping for the key, the old value is replaced by the specified value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final ImageContentUrl imageContentUrl = (ImageContentUrl) o;
    return Objects.equals(this.cloudSdkCustomFields, imageContentUrl.cloudSdkCustomFields)
        && Objects.equals(this.url, imageContentUrl.url)
        && Objects.equals(this.detail, imageContentUrl.detail);
  }

  @Override
  public int hashCode() {
    return Objects.hash(url, detail, cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class ImageContentUrl {\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    detail: ").append(toIndentedString(detail)).append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create a type-safe, fluent-api builder object to construct a new {@link ImageContentUrl}
   * instance with all required arguments.
   */
  public static Builder create() {
    return (url) -> new ImageContentUrl().url(url);
  }

  /** Builder helper class. */
  public interface Builder {
    /**
     * Set the url of this {@link ImageContentUrl} instance.
     *
     * @param url The url of this {@link ImageContentUrl}
     * @return The ImageContentUrl instance.
     */
    ImageContentUrl url(@Nonnull final String url);
  }
}
