/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/** LLMChoice */
// CHECKSTYLE:OFF
public class LLMChoice
// CHECKSTYLE:ON
{
  @JsonProperty("index")
  private Integer index;

  @JsonProperty("message")
  private ResponseChatMessage message;

  @JsonProperty("logprobs")
  private ChoiceLogprobs logprobs;

  @JsonProperty("finish_reason")
  private String finishReason;

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for LLMChoice. */
  protected LLMChoice() {}

  /**
   * Set the index of this {@link LLMChoice} instance and return the same instance.
   *
   * @param index Index of the choice
   * @return The same instance of this {@link LLMChoice} class
   */
  @Nonnull
  public LLMChoice index(@Nonnull final Integer index) {
    this.index = index;
    return this;
  }

  /**
   * Index of the choice
   *
   * @return index The index of this {@link LLMChoice} instance.
   */
  @Nonnull
  public Integer getIndex() {
    return index;
  }

  /**
   * Set the index of this {@link LLMChoice} instance.
   *
   * @param index Index of the choice
   */
  public void setIndex(@Nonnull final Integer index) {
    this.index = index;
  }

  /**
   * Set the message of this {@link LLMChoice} instance and return the same instance.
   *
   * @param message The message of this {@link LLMChoice}
   * @return The same instance of this {@link LLMChoice} class
   */
  @Nonnull
  public LLMChoice message(@Nonnull final ResponseChatMessage message) {
    this.message = message;
    return this;
  }

  /**
   * Get message
   *
   * @return message The message of this {@link LLMChoice} instance.
   */
  @Nonnull
  public ResponseChatMessage getMessage() {
    return message;
  }

  /**
   * Set the message of this {@link LLMChoice} instance.
   *
   * @param message The message of this {@link LLMChoice}
   */
  public void setMessage(@Nonnull final ResponseChatMessage message) {
    this.message = message;
  }

  /**
   * Set the logprobs of this {@link LLMChoice} instance and return the same instance.
   *
   * @param logprobs The logprobs of this {@link LLMChoice}
   * @return The same instance of this {@link LLMChoice} class
   */
  @Nonnull
  public LLMChoice logprobs(@Nullable final ChoiceLogprobs logprobs) {
    this.logprobs = logprobs;
    return this;
  }

  /**
   * Get logprobs
   *
   * @return logprobs The logprobs of this {@link LLMChoice} instance.
   */
  @Nonnull
  public ChoiceLogprobs getLogprobs() {
    return logprobs;
  }

  /**
   * Set the logprobs of this {@link LLMChoice} instance.
   *
   * @param logprobs The logprobs of this {@link LLMChoice}
   */
  public void setLogprobs(@Nullable final ChoiceLogprobs logprobs) {
    this.logprobs = logprobs;
  }

  /**
   * Set the finishReason of this {@link LLMChoice} instance and return the same instance.
   *
   * @param finishReason Reason the model stopped generating tokens. &#39;stop&#39; if the model hit
   *     a natural stop point or a provided stop sequence, &#39;length&#39; if the maximum token
   *     number was reached, &#39;content_filter&#39; if content was omitted due to a filter
   *     enforced by the LLM model provider or the content filtering module
   * @return The same instance of this {@link LLMChoice} class
   */
  @Nonnull
  public LLMChoice finishReason(@Nonnull final String finishReason) {
    this.finishReason = finishReason;
    return this;
  }

  /**
   * Reason the model stopped generating tokens. &#39;stop&#39; if the model hit a natural stop
   * point or a provided stop sequence, &#39;length&#39; if the maximum token number was reached,
   * &#39;content_filter&#39; if content was omitted due to a filter enforced by the LLM model
   * provider or the content filtering module
   *
   * @return finishReason The finishReason of this {@link LLMChoice} instance.
   */
  @Nonnull
  public String getFinishReason() {
    return finishReason;
  }

  /**
   * Set the finishReason of this {@link LLMChoice} instance.
   *
   * @param finishReason Reason the model stopped generating tokens. &#39;stop&#39; if the model hit
   *     a natural stop point or a provided stop sequence, &#39;length&#39; if the maximum token
   *     number was reached, &#39;content_filter&#39; if content was omitted due to a filter
   *     enforced by the LLM model provider or the content filtering module
   */
  public void setFinishReason(@Nonnull final String finishReason) {
    this.finishReason = finishReason;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link LLMChoice}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link LLMChoice} instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException("LLMChoice has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link LLMChoice} instance including unrecognized
   * properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (index != null) declaredFields.put("index", index);
    if (message != null) declaredFields.put("message", message);
    if (logprobs != null) declaredFields.put("logprobs", logprobs);
    if (finishReason != null) declaredFields.put("finishReason", finishReason);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link LLMChoice} instance. If the map previously
   * contained a mapping for the key, the old value is replaced by the specified value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final LLMChoice llMChoice = (LLMChoice) o;
    return Objects.equals(this.cloudSdkCustomFields, llMChoice.cloudSdkCustomFields)
        && Objects.equals(this.index, llMChoice.index)
        && Objects.equals(this.message, llMChoice.message)
        && Objects.equals(this.logprobs, llMChoice.logprobs)
        && Objects.equals(this.finishReason, llMChoice.finishReason);
  }

  @Override
  public int hashCode() {
    return Objects.hash(index, message, logprobs, finishReason, cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class LLMChoice {\n");
    sb.append("    index: ").append(toIndentedString(index)).append("\n");
    sb.append("    message: ").append(toIndentedString(message)).append("\n");
    sb.append("    logprobs: ").append(toIndentedString(logprobs)).append("\n");
    sb.append("    finishReason: ").append(toIndentedString(finishReason)).append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create a type-safe, fluent-api builder object to construct a new {@link LLMChoice} instance
   * with all required arguments.
   */
  public static Builder create() {
    return (index) ->
        (message) ->
            (finishReason) ->
                new LLMChoice().index(index).message(message).finishReason(finishReason);
  }

  /** Builder helper class. */
  public interface Builder {
    /**
     * Set the index of this {@link LLMChoice} instance.
     *
     * @param index Index of the choice
     * @return The LLMChoice builder.
     */
    Builder1 index(@Nonnull final Integer index);
  }

  /** Builder helper class. */
  public interface Builder1 {
    /**
     * Set the message of this {@link LLMChoice} instance.
     *
     * @param message The message of this {@link LLMChoice}
     * @return The LLMChoice builder.
     */
    Builder2 message(@Nonnull final ResponseChatMessage message);
  }

  /** Builder helper class. */
  public interface Builder2 {
    /**
     * Set the finishReason of this {@link LLMChoice} instance.
     *
     * @param finishReason Reason the model stopped generating tokens. &#39;stop&#39; if the model
     *     hit a natural stop point or a provided stop sequence, &#39;length&#39; if the maximum
     *     token number was reached, &#39;content_filter&#39; if content was omitted due to a filter
     *     enforced by the LLM model provider or the content filtering module
     * @return The LLMChoice instance.
     */
    LLMChoice finishReason(@Nonnull final String finishReason);
  }
}
