/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/** LLMChoiceStreaming */
// CHECKSTYLE:OFF
public class LLMChoiceStreaming
// CHECKSTYLE:ON
{
  @JsonProperty("index")
  private Integer index;

  @JsonProperty("delta")
  private ChatDelta delta;

  @JsonProperty("logprobs")
  private ChoiceLogprobs logprobs;

  @JsonProperty("finish_reason")
  private String finishReason;

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for LLMChoiceStreaming. */
  protected LLMChoiceStreaming() {}

  /**
   * Set the index of this {@link LLMChoiceStreaming} instance and return the same instance.
   *
   * @param index Index of the choice
   * @return The same instance of this {@link LLMChoiceStreaming} class
   */
  @Nonnull
  public LLMChoiceStreaming index(@Nonnull final Integer index) {
    this.index = index;
    return this;
  }

  /**
   * Index of the choice
   *
   * @return index The index of this {@link LLMChoiceStreaming} instance.
   */
  @Nonnull
  public Integer getIndex() {
    return index;
  }

  /**
   * Set the index of this {@link LLMChoiceStreaming} instance.
   *
   * @param index Index of the choice
   */
  public void setIndex(@Nonnull final Integer index) {
    this.index = index;
  }

  /**
   * Set the delta of this {@link LLMChoiceStreaming} instance and return the same instance.
   *
   * @param delta The delta of this {@link LLMChoiceStreaming}
   * @return The same instance of this {@link LLMChoiceStreaming} class
   */
  @Nonnull
  public LLMChoiceStreaming delta(@Nonnull final ChatDelta delta) {
    this.delta = delta;
    return this;
  }

  /**
   * Get delta
   *
   * @return delta The delta of this {@link LLMChoiceStreaming} instance.
   */
  @Nonnull
  public ChatDelta getDelta() {
    return delta;
  }

  /**
   * Set the delta of this {@link LLMChoiceStreaming} instance.
   *
   * @param delta The delta of this {@link LLMChoiceStreaming}
   */
  public void setDelta(@Nonnull final ChatDelta delta) {
    this.delta = delta;
  }

  /**
   * Set the logprobs of this {@link LLMChoiceStreaming} instance and return the same instance.
   *
   * @param logprobs The logprobs of this {@link LLMChoiceStreaming}
   * @return The same instance of this {@link LLMChoiceStreaming} class
   */
  @Nonnull
  public LLMChoiceStreaming logprobs(@Nullable final ChoiceLogprobs logprobs) {
    this.logprobs = logprobs;
    return this;
  }

  /**
   * Get logprobs
   *
   * @return logprobs The logprobs of this {@link LLMChoiceStreaming} instance.
   */
  @Nonnull
  public ChoiceLogprobs getLogprobs() {
    return logprobs;
  }

  /**
   * Set the logprobs of this {@link LLMChoiceStreaming} instance.
   *
   * @param logprobs The logprobs of this {@link LLMChoiceStreaming}
   */
  public void setLogprobs(@Nullable final ChoiceLogprobs logprobs) {
    this.logprobs = logprobs;
  }

  /**
   * Set the finishReason of this {@link LLMChoiceStreaming} instance and return the same instance.
   *
   * @param finishReason Reason for stopping the model
   * @return The same instance of this {@link LLMChoiceStreaming} class
   */
  @Nonnull
  public LLMChoiceStreaming finishReason(@Nullable final String finishReason) {
    this.finishReason = finishReason;
    return this;
  }

  /**
   * Reason for stopping the model
   *
   * @return finishReason The finishReason of this {@link LLMChoiceStreaming} instance.
   */
  @Nonnull
  public String getFinishReason() {
    return finishReason;
  }

  /**
   * Set the finishReason of this {@link LLMChoiceStreaming} instance.
   *
   * @param finishReason Reason for stopping the model
   */
  public void setFinishReason(@Nullable final String finishReason) {
    this.finishReason = finishReason;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link LLMChoiceStreaming}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link LLMChoiceStreaming} instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException("LLMChoiceStreaming has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link LLMChoiceStreaming} instance including
   * unrecognized properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (index != null) declaredFields.put("index", index);
    if (delta != null) declaredFields.put("delta", delta);
    if (logprobs != null) declaredFields.put("logprobs", logprobs);
    if (finishReason != null) declaredFields.put("finishReason", finishReason);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link LLMChoiceStreaming} instance. If the map
   * previously contained a mapping for the key, the old value is replaced by the specified value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final LLMChoiceStreaming llMChoiceStreaming = (LLMChoiceStreaming) o;
    return Objects.equals(this.cloudSdkCustomFields, llMChoiceStreaming.cloudSdkCustomFields)
        && Objects.equals(this.index, llMChoiceStreaming.index)
        && Objects.equals(this.delta, llMChoiceStreaming.delta)
        && Objects.equals(this.logprobs, llMChoiceStreaming.logprobs)
        && Objects.equals(this.finishReason, llMChoiceStreaming.finishReason);
  }

  @Override
  public int hashCode() {
    return Objects.hash(index, delta, logprobs, finishReason, cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class LLMChoiceStreaming {\n");
    sb.append("    index: ").append(toIndentedString(index)).append("\n");
    sb.append("    delta: ").append(toIndentedString(delta)).append("\n");
    sb.append("    logprobs: ").append(toIndentedString(logprobs)).append("\n");
    sb.append("    finishReason: ").append(toIndentedString(finishReason)).append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create a type-safe, fluent-api builder object to construct a new {@link LLMChoiceStreaming}
   * instance with all required arguments.
   */
  public static Builder create() {
    return (index) -> (delta) -> new LLMChoiceStreaming().index(index).delta(delta);
  }

  /** Builder helper class. */
  public interface Builder {
    /**
     * Set the index of this {@link LLMChoiceStreaming} instance.
     *
     * @param index Index of the choice
     * @return The LLMChoiceStreaming builder.
     */
    Builder1 index(@Nonnull final Integer index);
  }

  /** Builder helper class. */
  public interface Builder1 {
    /**
     * Set the delta of this {@link LLMChoiceStreaming} instance.
     *
     * @param delta The delta of this {@link LLMChoiceStreaming}
     * @return The LLMChoiceStreaming instance.
     */
    LLMChoiceStreaming delta(@Nonnull final ChatDelta delta);
  }
}
