/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/** LLMModuleConfig */
// CHECKSTYLE:OFF
public class LLMModuleConfig
// CHECKSTYLE:ON
{
  @JsonProperty("model_name")
  private String modelName;

  @JsonProperty("model_params")
  private Map<String, Object> modelParams = new HashMap<>();

  @JsonProperty("model_version")
  private String modelVersion = "latest";

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for LLMModuleConfig. */
  protected LLMModuleConfig() {}

  /**
   * Set the modelName of this {@link LLMModuleConfig} instance and return the same instance.
   *
   * @param modelName Model name as in LLM Access configuration
   * @return The same instance of this {@link LLMModuleConfig} class
   */
  @Nonnull
  public LLMModuleConfig modelName(@Nonnull final String modelName) {
    this.modelName = modelName;
    return this;
  }

  /**
   * Model name as in LLM Access configuration
   *
   * @return modelName The modelName of this {@link LLMModuleConfig} instance.
   */
  @Nonnull
  public String getModelName() {
    return modelName;
  }

  /**
   * Set the modelName of this {@link LLMModuleConfig} instance.
   *
   * @param modelName Model name as in LLM Access configuration
   */
  public void setModelName(@Nonnull final String modelName) {
    this.modelName = modelName;
  }

  /**
   * Set the modelParams of this {@link LLMModuleConfig} instance and return the same instance.
   *
   * @param modelParams Model parameters
   * @return The same instance of this {@link LLMModuleConfig} class
   */
  @Nonnull
  public LLMModuleConfig modelParams(@Nullable final Map<String, Object> modelParams) {
    this.modelParams = modelParams;
    return this;
  }

  /**
   * Put one modelParams instance to this {@link LLMModuleConfig} instance.
   *
   * @param key The String key of this modelParams instance
   * @param modelParamsItem The modelParams that should be added under the given key
   * @return The same instance of type {@link LLMModuleConfig}
   */
  @Nonnull
  public LLMModuleConfig putmodelParamsItem(
      @Nonnull final String key, @Nullable final Object modelParamsItem) {
    if (this.modelParams == null) {
      this.modelParams = new HashMap<>();
    }
    this.modelParams.put(key, modelParamsItem);
    return this;
  }

  /**
   * Model parameters
   *
   * @return modelParams The modelParams of this {@link LLMModuleConfig} instance.
   */
  @Nonnull
  public Map<String, Object> getModelParams() {
    return modelParams;
  }

  /**
   * Set the modelParams of this {@link LLMModuleConfig} instance.
   *
   * @param modelParams Model parameters
   */
  public void setModelParams(@Nullable final Map<String, Object> modelParams) {
    this.modelParams = modelParams;
  }

  /**
   * Set the modelVersion of this {@link LLMModuleConfig} instance and return the same instance.
   *
   * @param modelVersion Version of the model to use
   * @return The same instance of this {@link LLMModuleConfig} class
   */
  @Nonnull
  public LLMModuleConfig modelVersion(@Nullable final String modelVersion) {
    this.modelVersion = modelVersion;
    return this;
  }

  /**
   * Version of the model to use
   *
   * @return modelVersion The modelVersion of this {@link LLMModuleConfig} instance.
   */
  @Nonnull
  public String getModelVersion() {
    return modelVersion;
  }

  /**
   * Set the modelVersion of this {@link LLMModuleConfig} instance.
   *
   * @param modelVersion Version of the model to use
   */
  public void setModelVersion(@Nullable final String modelVersion) {
    this.modelVersion = modelVersion;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link LLMModuleConfig}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link LLMModuleConfig} instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException("LLMModuleConfig has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link LLMModuleConfig} instance including unrecognized
   * properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (modelName != null) declaredFields.put("modelName", modelName);
    if (modelParams != null) declaredFields.put("modelParams", modelParams);
    if (modelVersion != null) declaredFields.put("modelVersion", modelVersion);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link LLMModuleConfig} instance. If the map previously
   * contained a mapping for the key, the old value is replaced by the specified value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final LLMModuleConfig llMModuleConfig = (LLMModuleConfig) o;
    return Objects.equals(this.cloudSdkCustomFields, llMModuleConfig.cloudSdkCustomFields)
        && Objects.equals(this.modelName, llMModuleConfig.modelName)
        && Objects.equals(this.modelParams, llMModuleConfig.modelParams)
        && Objects.equals(this.modelVersion, llMModuleConfig.modelVersion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(modelName, modelParams, modelVersion, cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class LLMModuleConfig {\n");
    sb.append("    modelName: ").append(toIndentedString(modelName)).append("\n");
    sb.append("    modelParams: ").append(toIndentedString(modelParams)).append("\n");
    sb.append("    modelVersion: ").append(toIndentedString(modelVersion)).append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create a type-safe, fluent-api builder object to construct a new {@link LLMModuleConfig}
   * instance with all required arguments.
   */
  public static Builder create() {
    return (modelName) -> new LLMModuleConfig().modelName(modelName);
  }

  /** Builder helper class. */
  public interface Builder {
    /**
     * Set the modelName of this {@link LLMModuleConfig} instance.
     *
     * @param modelName Model name as in LLM Access configuration
     * @return The LLMModuleConfig instance.
     */
    LLMModuleConfig modelName(@Nonnull final String modelName);
  }
}
