/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/** Filter configuration for Llama Guard 3 8B */
// CHECKSTYLE:OFF
public class LlamaGuard38b
// CHECKSTYLE:ON
{
  @JsonProperty("violent_crimes")
  private Boolean violentCrimes;

  @JsonProperty("non_violent_crimes")
  private Boolean nonViolentCrimes;

  @JsonProperty("sex_crimes")
  private Boolean sexCrimes;

  @JsonProperty("child_exploitation")
  private Boolean childExploitation;

  @JsonProperty("defamation")
  private Boolean defamation;

  @JsonProperty("specialized_advice")
  private Boolean specializedAdvice;

  @JsonProperty("privacy")
  private Boolean privacy;

  @JsonProperty("intellectual_property")
  private Boolean intellectualProperty;

  @JsonProperty("indiscriminate_weapons")
  private Boolean indiscriminateWeapons;

  @JsonProperty("hate")
  private Boolean hate;

  @JsonProperty("self_harm")
  private Boolean selfHarm;

  @JsonProperty("sexual_content")
  private Boolean sexualContent;

  @JsonProperty("elections")
  private Boolean elections;

  @JsonProperty("code_interpreter_abuse")
  private Boolean codeInterpreterAbuse;

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for LlamaGuard38b. */
  protected LlamaGuard38b() {}

  /**
   * Set the violentCrimes of this {@link LlamaGuard38b} instance and return the same instance.
   *
   * @param violentCrimes The violentCrimes of this {@link LlamaGuard38b}
   * @return The same instance of this {@link LlamaGuard38b} class
   */
  @Nonnull
  public LlamaGuard38b violentCrimes(@Nullable final Boolean violentCrimes) {
    this.violentCrimes = violentCrimes;
    return this;
  }

  /**
   * Get violentCrimes
   *
   * @return violentCrimes The violentCrimes of this {@link LlamaGuard38b} instance.
   */
  @Nonnull
  public Boolean isViolentCrimes() {
    return violentCrimes;
  }

  /**
   * Set the violentCrimes of this {@link LlamaGuard38b} instance.
   *
   * @param violentCrimes The violentCrimes of this {@link LlamaGuard38b}
   */
  public void setViolentCrimes(@Nullable final Boolean violentCrimes) {
    this.violentCrimes = violentCrimes;
  }

  /**
   * Set the nonViolentCrimes of this {@link LlamaGuard38b} instance and return the same instance.
   *
   * @param nonViolentCrimes The nonViolentCrimes of this {@link LlamaGuard38b}
   * @return The same instance of this {@link LlamaGuard38b} class
   */
  @Nonnull
  public LlamaGuard38b nonViolentCrimes(@Nullable final Boolean nonViolentCrimes) {
    this.nonViolentCrimes = nonViolentCrimes;
    return this;
  }

  /**
   * Get nonViolentCrimes
   *
   * @return nonViolentCrimes The nonViolentCrimes of this {@link LlamaGuard38b} instance.
   */
  @Nonnull
  public Boolean isNonViolentCrimes() {
    return nonViolentCrimes;
  }

  /**
   * Set the nonViolentCrimes of this {@link LlamaGuard38b} instance.
   *
   * @param nonViolentCrimes The nonViolentCrimes of this {@link LlamaGuard38b}
   */
  public void setNonViolentCrimes(@Nullable final Boolean nonViolentCrimes) {
    this.nonViolentCrimes = nonViolentCrimes;
  }

  /**
   * Set the sexCrimes of this {@link LlamaGuard38b} instance and return the same instance.
   *
   * @param sexCrimes The sexCrimes of this {@link LlamaGuard38b}
   * @return The same instance of this {@link LlamaGuard38b} class
   */
  @Nonnull
  public LlamaGuard38b sexCrimes(@Nullable final Boolean sexCrimes) {
    this.sexCrimes = sexCrimes;
    return this;
  }

  /**
   * Get sexCrimes
   *
   * @return sexCrimes The sexCrimes of this {@link LlamaGuard38b} instance.
   */
  @Nonnull
  public Boolean isSexCrimes() {
    return sexCrimes;
  }

  /**
   * Set the sexCrimes of this {@link LlamaGuard38b} instance.
   *
   * @param sexCrimes The sexCrimes of this {@link LlamaGuard38b}
   */
  public void setSexCrimes(@Nullable final Boolean sexCrimes) {
    this.sexCrimes = sexCrimes;
  }

  /**
   * Set the childExploitation of this {@link LlamaGuard38b} instance and return the same instance.
   *
   * @param childExploitation The childExploitation of this {@link LlamaGuard38b}
   * @return The same instance of this {@link LlamaGuard38b} class
   */
  @Nonnull
  public LlamaGuard38b childExploitation(@Nullable final Boolean childExploitation) {
    this.childExploitation = childExploitation;
    return this;
  }

  /**
   * Get childExploitation
   *
   * @return childExploitation The childExploitation of this {@link LlamaGuard38b} instance.
   */
  @Nonnull
  public Boolean isChildExploitation() {
    return childExploitation;
  }

  /**
   * Set the childExploitation of this {@link LlamaGuard38b} instance.
   *
   * @param childExploitation The childExploitation of this {@link LlamaGuard38b}
   */
  public void setChildExploitation(@Nullable final Boolean childExploitation) {
    this.childExploitation = childExploitation;
  }

  /**
   * Set the defamation of this {@link LlamaGuard38b} instance and return the same instance.
   *
   * @param defamation The defamation of this {@link LlamaGuard38b}
   * @return The same instance of this {@link LlamaGuard38b} class
   */
  @Nonnull
  public LlamaGuard38b defamation(@Nullable final Boolean defamation) {
    this.defamation = defamation;
    return this;
  }

  /**
   * Get defamation
   *
   * @return defamation The defamation of this {@link LlamaGuard38b} instance.
   */
  @Nonnull
  public Boolean isDefamation() {
    return defamation;
  }

  /**
   * Set the defamation of this {@link LlamaGuard38b} instance.
   *
   * @param defamation The defamation of this {@link LlamaGuard38b}
   */
  public void setDefamation(@Nullable final Boolean defamation) {
    this.defamation = defamation;
  }

  /**
   * Set the specializedAdvice of this {@link LlamaGuard38b} instance and return the same instance.
   *
   * @param specializedAdvice The specializedAdvice of this {@link LlamaGuard38b}
   * @return The same instance of this {@link LlamaGuard38b} class
   */
  @Nonnull
  public LlamaGuard38b specializedAdvice(@Nullable final Boolean specializedAdvice) {
    this.specializedAdvice = specializedAdvice;
    return this;
  }

  /**
   * Get specializedAdvice
   *
   * @return specializedAdvice The specializedAdvice of this {@link LlamaGuard38b} instance.
   */
  @Nonnull
  public Boolean isSpecializedAdvice() {
    return specializedAdvice;
  }

  /**
   * Set the specializedAdvice of this {@link LlamaGuard38b} instance.
   *
   * @param specializedAdvice The specializedAdvice of this {@link LlamaGuard38b}
   */
  public void setSpecializedAdvice(@Nullable final Boolean specializedAdvice) {
    this.specializedAdvice = specializedAdvice;
  }

  /**
   * Set the privacy of this {@link LlamaGuard38b} instance and return the same instance.
   *
   * @param privacy The privacy of this {@link LlamaGuard38b}
   * @return The same instance of this {@link LlamaGuard38b} class
   */
  @Nonnull
  public LlamaGuard38b privacy(@Nullable final Boolean privacy) {
    this.privacy = privacy;
    return this;
  }

  /**
   * Get privacy
   *
   * @return privacy The privacy of this {@link LlamaGuard38b} instance.
   */
  @Nonnull
  public Boolean isPrivacy() {
    return privacy;
  }

  /**
   * Set the privacy of this {@link LlamaGuard38b} instance.
   *
   * @param privacy The privacy of this {@link LlamaGuard38b}
   */
  public void setPrivacy(@Nullable final Boolean privacy) {
    this.privacy = privacy;
  }

  /**
   * Set the intellectualProperty of this {@link LlamaGuard38b} instance and return the same
   * instance.
   *
   * @param intellectualProperty The intellectualProperty of this {@link LlamaGuard38b}
   * @return The same instance of this {@link LlamaGuard38b} class
   */
  @Nonnull
  public LlamaGuard38b intellectualProperty(@Nullable final Boolean intellectualProperty) {
    this.intellectualProperty = intellectualProperty;
    return this;
  }

  /**
   * Get intellectualProperty
   *
   * @return intellectualProperty The intellectualProperty of this {@link LlamaGuard38b} instance.
   */
  @Nonnull
  public Boolean isIntellectualProperty() {
    return intellectualProperty;
  }

  /**
   * Set the intellectualProperty of this {@link LlamaGuard38b} instance.
   *
   * @param intellectualProperty The intellectualProperty of this {@link LlamaGuard38b}
   */
  public void setIntellectualProperty(@Nullable final Boolean intellectualProperty) {
    this.intellectualProperty = intellectualProperty;
  }

  /**
   * Set the indiscriminateWeapons of this {@link LlamaGuard38b} instance and return the same
   * instance.
   *
   * @param indiscriminateWeapons The indiscriminateWeapons of this {@link LlamaGuard38b}
   * @return The same instance of this {@link LlamaGuard38b} class
   */
  @Nonnull
  public LlamaGuard38b indiscriminateWeapons(@Nullable final Boolean indiscriminateWeapons) {
    this.indiscriminateWeapons = indiscriminateWeapons;
    return this;
  }

  /**
   * Get indiscriminateWeapons
   *
   * @return indiscriminateWeapons The indiscriminateWeapons of this {@link LlamaGuard38b} instance.
   */
  @Nonnull
  public Boolean isIndiscriminateWeapons() {
    return indiscriminateWeapons;
  }

  /**
   * Set the indiscriminateWeapons of this {@link LlamaGuard38b} instance.
   *
   * @param indiscriminateWeapons The indiscriminateWeapons of this {@link LlamaGuard38b}
   */
  public void setIndiscriminateWeapons(@Nullable final Boolean indiscriminateWeapons) {
    this.indiscriminateWeapons = indiscriminateWeapons;
  }

  /**
   * Set the hate of this {@link LlamaGuard38b} instance and return the same instance.
   *
   * @param hate The hate of this {@link LlamaGuard38b}
   * @return The same instance of this {@link LlamaGuard38b} class
   */
  @Nonnull
  public LlamaGuard38b hate(@Nullable final Boolean hate) {
    this.hate = hate;
    return this;
  }

  /**
   * Get hate
   *
   * @return hate The hate of this {@link LlamaGuard38b} instance.
   */
  @Nonnull
  public Boolean isHate() {
    return hate;
  }

  /**
   * Set the hate of this {@link LlamaGuard38b} instance.
   *
   * @param hate The hate of this {@link LlamaGuard38b}
   */
  public void setHate(@Nullable final Boolean hate) {
    this.hate = hate;
  }

  /**
   * Set the selfHarm of this {@link LlamaGuard38b} instance and return the same instance.
   *
   * @param selfHarm The selfHarm of this {@link LlamaGuard38b}
   * @return The same instance of this {@link LlamaGuard38b} class
   */
  @Nonnull
  public LlamaGuard38b selfHarm(@Nullable final Boolean selfHarm) {
    this.selfHarm = selfHarm;
    return this;
  }

  /**
   * Get selfHarm
   *
   * @return selfHarm The selfHarm of this {@link LlamaGuard38b} instance.
   */
  @Nonnull
  public Boolean isSelfHarm() {
    return selfHarm;
  }

  /**
   * Set the selfHarm of this {@link LlamaGuard38b} instance.
   *
   * @param selfHarm The selfHarm of this {@link LlamaGuard38b}
   */
  public void setSelfHarm(@Nullable final Boolean selfHarm) {
    this.selfHarm = selfHarm;
  }

  /**
   * Set the sexualContent of this {@link LlamaGuard38b} instance and return the same instance.
   *
   * @param sexualContent The sexualContent of this {@link LlamaGuard38b}
   * @return The same instance of this {@link LlamaGuard38b} class
   */
  @Nonnull
  public LlamaGuard38b sexualContent(@Nullable final Boolean sexualContent) {
    this.sexualContent = sexualContent;
    return this;
  }

  /**
   * Get sexualContent
   *
   * @return sexualContent The sexualContent of this {@link LlamaGuard38b} instance.
   */
  @Nonnull
  public Boolean isSexualContent() {
    return sexualContent;
  }

  /**
   * Set the sexualContent of this {@link LlamaGuard38b} instance.
   *
   * @param sexualContent The sexualContent of this {@link LlamaGuard38b}
   */
  public void setSexualContent(@Nullable final Boolean sexualContent) {
    this.sexualContent = sexualContent;
  }

  /**
   * Set the elections of this {@link LlamaGuard38b} instance and return the same instance.
   *
   * @param elections The elections of this {@link LlamaGuard38b}
   * @return The same instance of this {@link LlamaGuard38b} class
   */
  @Nonnull
  public LlamaGuard38b elections(@Nullable final Boolean elections) {
    this.elections = elections;
    return this;
  }

  /**
   * Get elections
   *
   * @return elections The elections of this {@link LlamaGuard38b} instance.
   */
  @Nonnull
  public Boolean isElections() {
    return elections;
  }

  /**
   * Set the elections of this {@link LlamaGuard38b} instance.
   *
   * @param elections The elections of this {@link LlamaGuard38b}
   */
  public void setElections(@Nullable final Boolean elections) {
    this.elections = elections;
  }

  /**
   * Set the codeInterpreterAbuse of this {@link LlamaGuard38b} instance and return the same
   * instance.
   *
   * @param codeInterpreterAbuse The codeInterpreterAbuse of this {@link LlamaGuard38b}
   * @return The same instance of this {@link LlamaGuard38b} class
   */
  @Nonnull
  public LlamaGuard38b codeInterpreterAbuse(@Nullable final Boolean codeInterpreterAbuse) {
    this.codeInterpreterAbuse = codeInterpreterAbuse;
    return this;
  }

  /**
   * Get codeInterpreterAbuse
   *
   * @return codeInterpreterAbuse The codeInterpreterAbuse of this {@link LlamaGuard38b} instance.
   */
  @Nonnull
  public Boolean isCodeInterpreterAbuse() {
    return codeInterpreterAbuse;
  }

  /**
   * Set the codeInterpreterAbuse of this {@link LlamaGuard38b} instance.
   *
   * @param codeInterpreterAbuse The codeInterpreterAbuse of this {@link LlamaGuard38b}
   */
  public void setCodeInterpreterAbuse(@Nullable final Boolean codeInterpreterAbuse) {
    this.codeInterpreterAbuse = codeInterpreterAbuse;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link LlamaGuard38b}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link LlamaGuard38b} instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException("LlamaGuard38b has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link LlamaGuard38b} instance including unrecognized
   * properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (violentCrimes != null) declaredFields.put("violentCrimes", violentCrimes);
    if (nonViolentCrimes != null) declaredFields.put("nonViolentCrimes", nonViolentCrimes);
    if (sexCrimes != null) declaredFields.put("sexCrimes", sexCrimes);
    if (childExploitation != null) declaredFields.put("childExploitation", childExploitation);
    if (defamation != null) declaredFields.put("defamation", defamation);
    if (specializedAdvice != null) declaredFields.put("specializedAdvice", specializedAdvice);
    if (privacy != null) declaredFields.put("privacy", privacy);
    if (intellectualProperty != null)
      declaredFields.put("intellectualProperty", intellectualProperty);
    if (indiscriminateWeapons != null)
      declaredFields.put("indiscriminateWeapons", indiscriminateWeapons);
    if (hate != null) declaredFields.put("hate", hate);
    if (selfHarm != null) declaredFields.put("selfHarm", selfHarm);
    if (sexualContent != null) declaredFields.put("sexualContent", sexualContent);
    if (elections != null) declaredFields.put("elections", elections);
    if (codeInterpreterAbuse != null)
      declaredFields.put("codeInterpreterAbuse", codeInterpreterAbuse);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link LlamaGuard38b} instance. If the map previously
   * contained a mapping for the key, the old value is replaced by the specified value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final LlamaGuard38b llamaGuard38b = (LlamaGuard38b) o;
    return Objects.equals(this.cloudSdkCustomFields, llamaGuard38b.cloudSdkCustomFields)
        && Objects.equals(this.violentCrimes, llamaGuard38b.violentCrimes)
        && Objects.equals(this.nonViolentCrimes, llamaGuard38b.nonViolentCrimes)
        && Objects.equals(this.sexCrimes, llamaGuard38b.sexCrimes)
        && Objects.equals(this.childExploitation, llamaGuard38b.childExploitation)
        && Objects.equals(this.defamation, llamaGuard38b.defamation)
        && Objects.equals(this.specializedAdvice, llamaGuard38b.specializedAdvice)
        && Objects.equals(this.privacy, llamaGuard38b.privacy)
        && Objects.equals(this.intellectualProperty, llamaGuard38b.intellectualProperty)
        && Objects.equals(this.indiscriminateWeapons, llamaGuard38b.indiscriminateWeapons)
        && Objects.equals(this.hate, llamaGuard38b.hate)
        && Objects.equals(this.selfHarm, llamaGuard38b.selfHarm)
        && Objects.equals(this.sexualContent, llamaGuard38b.sexualContent)
        && Objects.equals(this.elections, llamaGuard38b.elections)
        && Objects.equals(this.codeInterpreterAbuse, llamaGuard38b.codeInterpreterAbuse);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        violentCrimes,
        nonViolentCrimes,
        sexCrimes,
        childExploitation,
        defamation,
        specializedAdvice,
        privacy,
        intellectualProperty,
        indiscriminateWeapons,
        hate,
        selfHarm,
        sexualContent,
        elections,
        codeInterpreterAbuse,
        cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class LlamaGuard38b {\n");
    sb.append("    violentCrimes: ").append(toIndentedString(violentCrimes)).append("\n");
    sb.append("    nonViolentCrimes: ").append(toIndentedString(nonViolentCrimes)).append("\n");
    sb.append("    sexCrimes: ").append(toIndentedString(sexCrimes)).append("\n");
    sb.append("    childExploitation: ").append(toIndentedString(childExploitation)).append("\n");
    sb.append("    defamation: ").append(toIndentedString(defamation)).append("\n");
    sb.append("    specializedAdvice: ").append(toIndentedString(specializedAdvice)).append("\n");
    sb.append("    privacy: ").append(toIndentedString(privacy)).append("\n");
    sb.append("    intellectualProperty: ")
        .append(toIndentedString(intellectualProperty))
        .append("\n");
    sb.append("    indiscriminateWeapons: ")
        .append(toIndentedString(indiscriminateWeapons))
        .append("\n");
    sb.append("    hate: ").append(toIndentedString(hate)).append("\n");
    sb.append("    selfHarm: ").append(toIndentedString(selfHarm)).append("\n");
    sb.append("    sexualContent: ").append(toIndentedString(sexualContent)).append("\n");
    sb.append("    elections: ").append(toIndentedString(elections)).append("\n");
    sb.append("    codeInterpreterAbuse: ")
        .append(toIndentedString(codeInterpreterAbuse))
        .append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /** Create a new {@link LlamaGuard38b} instance. No arguments are required. */
  public static LlamaGuard38b create() {
    return new LlamaGuard38b();
  }
}
