/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/** MaskingModuleConfig */
// CHECKSTYLE:OFF
public class MaskingModuleConfig
// CHECKSTYLE:ON
{
  @JsonProperty("masking_providers")
  private List<DPIConfig> maskingProviders = new ArrayList<>();

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for MaskingModuleConfig. */
  protected MaskingModuleConfig() {}

  /**
   * Set the maskingProviders of this {@link MaskingModuleConfig} instance and return the same
   * instance.
   *
   * @param maskingProviders List of masking service providers
   * @return The same instance of this {@link MaskingModuleConfig} class
   */
  @Nonnull
  public MaskingModuleConfig maskingProviders(@Nonnull final List<DPIConfig> maskingProviders) {
    this.maskingProviders = maskingProviders;
    return this;
  }

  /**
   * Add one maskingProviders instance to this {@link MaskingModuleConfig}.
   *
   * @param maskingProvidersItem The maskingProviders that should be added
   * @return The same instance of type {@link MaskingModuleConfig}
   */
  @Nonnull
  public MaskingModuleConfig addMaskingProvidersItem(
      @Nonnull final DPIConfig maskingProvidersItem) {
    if (this.maskingProviders == null) {
      this.maskingProviders = new ArrayList<>();
    }
    this.maskingProviders.add(maskingProvidersItem);
    return this;
  }

  /**
   * List of masking service providers
   *
   * @return maskingProviders The maskingProviders of this {@link MaskingModuleConfig} instance.
   */
  @Nonnull
  public List<DPIConfig> getMaskingProviders() {
    return maskingProviders;
  }

  /**
   * Set the maskingProviders of this {@link MaskingModuleConfig} instance.
   *
   * @param maskingProviders List of masking service providers
   */
  public void setMaskingProviders(@Nonnull final List<DPIConfig> maskingProviders) {
    this.maskingProviders = maskingProviders;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link MaskingModuleConfig}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link MaskingModuleConfig} instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException(
          "MaskingModuleConfig has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link MaskingModuleConfig} instance including
   * unrecognized properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (maskingProviders != null) declaredFields.put("maskingProviders", maskingProviders);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link MaskingModuleConfig} instance. If the map
   * previously contained a mapping for the key, the old value is replaced by the specified value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final MaskingModuleConfig maskingModuleConfig = (MaskingModuleConfig) o;
    return Objects.equals(this.cloudSdkCustomFields, maskingModuleConfig.cloudSdkCustomFields)
        && Objects.equals(this.maskingProviders, maskingModuleConfig.maskingProviders);
  }

  @Override
  public int hashCode() {
    return Objects.hash(maskingProviders, cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class MaskingModuleConfig {\n");
    sb.append("    maskingProviders: ").append(toIndentedString(maskingProviders)).append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create a type-safe, fluent-api builder object to construct a new {@link MaskingModuleConfig}
   * instance with all required arguments.
   */
  public static Builder create() {
    return (maskingProviders) -> new MaskingModuleConfig().maskingProviders(maskingProviders);
  }

  /** Builder helper class. */
  public interface Builder {
    /**
     * Set the maskingProviders of this {@link MaskingModuleConfig} instance.
     *
     * @param maskingProviders List of masking service providers
     * @return The MaskingModuleConfig instance.
     */
    MaskingModuleConfig maskingProviders(@Nonnull final List<DPIConfig> maskingProviders);

    /**
     * Set the maskingProviders of this {@link MaskingModuleConfig} instance.
     *
     * @param maskingProviders List of masking service providers
     * @return The MaskingModuleConfig instance.
     */
    default MaskingModuleConfig maskingProviders(@Nonnull final DPIConfig... maskingProviders) {
      return maskingProviders(Arrays.asList(maskingProviders));
    }
  }
}
