/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/** ModuleConfigs */
// CHECKSTYLE:OFF
public class ModuleConfigs
// CHECKSTYLE:ON
{
  @JsonProperty("llm_module_config")
  private LLMModuleConfig llmModuleConfig;

  @JsonProperty("templating_module_config")
  private TemplatingModuleConfig templatingModuleConfig;

  @JsonProperty("filtering_module_config")
  private FilteringModuleConfig filteringModuleConfig;

  @JsonProperty("masking_module_config")
  private MaskingModuleConfig maskingModuleConfig;

  @JsonProperty("grounding_module_config")
  private GroundingModuleConfig groundingModuleConfig;

  @JsonProperty("input_translation_module_config")
  private SAPDocumentTranslation inputTranslationModuleConfig;

  @JsonProperty("output_translation_module_config")
  private SAPDocumentTranslation outputTranslationModuleConfig;

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for ModuleConfigs. */
  protected ModuleConfigs() {}

  /**
   * Set the llmModuleConfig of this {@link ModuleConfigs} instance and return the same instance.
   *
   * @param llmModuleConfig The llmModuleConfig of this {@link ModuleConfigs}
   * @return The same instance of this {@link ModuleConfigs} class
   */
  @Nonnull
  public ModuleConfigs llmModuleConfig(@Nonnull final LLMModuleConfig llmModuleConfig) {
    this.llmModuleConfig = llmModuleConfig;
    return this;
  }

  /**
   * Get llmModuleConfig
   *
   * @return llmModuleConfig The llmModuleConfig of this {@link ModuleConfigs} instance.
   */
  @Nonnull
  public LLMModuleConfig getLlmModuleConfig() {
    return llmModuleConfig;
  }

  /**
   * Set the llmModuleConfig of this {@link ModuleConfigs} instance.
   *
   * @param llmModuleConfig The llmModuleConfig of this {@link ModuleConfigs}
   */
  public void setLlmModuleConfig(@Nonnull final LLMModuleConfig llmModuleConfig) {
    this.llmModuleConfig = llmModuleConfig;
  }

  /**
   * Set the templatingModuleConfig of this {@link ModuleConfigs} instance and return the same
   * instance.
   *
   * @param templatingModuleConfig The templatingModuleConfig of this {@link ModuleConfigs}
   * @return The same instance of this {@link ModuleConfigs} class
   */
  @Nonnull
  public ModuleConfigs templatingModuleConfig(
      @Nonnull final TemplatingModuleConfig templatingModuleConfig) {
    this.templatingModuleConfig = templatingModuleConfig;
    return this;
  }

  /**
   * Get templatingModuleConfig
   *
   * @return templatingModuleConfig The templatingModuleConfig of this {@link ModuleConfigs}
   *     instance.
   */
  @Nonnull
  public TemplatingModuleConfig getTemplatingModuleConfig() {
    return templatingModuleConfig;
  }

  /**
   * Set the templatingModuleConfig of this {@link ModuleConfigs} instance.
   *
   * @param templatingModuleConfig The templatingModuleConfig of this {@link ModuleConfigs}
   */
  public void setTemplatingModuleConfig(
      @Nonnull final TemplatingModuleConfig templatingModuleConfig) {
    this.templatingModuleConfig = templatingModuleConfig;
  }

  /**
   * Set the filteringModuleConfig of this {@link ModuleConfigs} instance and return the same
   * instance.
   *
   * @param filteringModuleConfig The filteringModuleConfig of this {@link ModuleConfigs}
   * @return The same instance of this {@link ModuleConfigs} class
   */
  @Nonnull
  public ModuleConfigs filteringModuleConfig(
      @Nullable final FilteringModuleConfig filteringModuleConfig) {
    this.filteringModuleConfig = filteringModuleConfig;
    return this;
  }

  /**
   * Get filteringModuleConfig
   *
   * @return filteringModuleConfig The filteringModuleConfig of this {@link ModuleConfigs} instance.
   */
  @Nonnull
  public FilteringModuleConfig getFilteringModuleConfig() {
    return filteringModuleConfig;
  }

  /**
   * Set the filteringModuleConfig of this {@link ModuleConfigs} instance.
   *
   * @param filteringModuleConfig The filteringModuleConfig of this {@link ModuleConfigs}
   */
  public void setFilteringModuleConfig(
      @Nullable final FilteringModuleConfig filteringModuleConfig) {
    this.filteringModuleConfig = filteringModuleConfig;
  }

  /**
   * Set the maskingModuleConfig of this {@link ModuleConfigs} instance and return the same
   * instance.
   *
   * @param maskingModuleConfig The maskingModuleConfig of this {@link ModuleConfigs}
   * @return The same instance of this {@link ModuleConfigs} class
   */
  @Nonnull
  public ModuleConfigs maskingModuleConfig(
      @Nullable final MaskingModuleConfig maskingModuleConfig) {
    this.maskingModuleConfig = maskingModuleConfig;
    return this;
  }

  /**
   * Get maskingModuleConfig
   *
   * @return maskingModuleConfig The maskingModuleConfig of this {@link ModuleConfigs} instance.
   */
  @Nonnull
  public MaskingModuleConfig getMaskingModuleConfig() {
    return maskingModuleConfig;
  }

  /**
   * Set the maskingModuleConfig of this {@link ModuleConfigs} instance.
   *
   * @param maskingModuleConfig The maskingModuleConfig of this {@link ModuleConfigs}
   */
  public void setMaskingModuleConfig(@Nullable final MaskingModuleConfig maskingModuleConfig) {
    this.maskingModuleConfig = maskingModuleConfig;
  }

  /**
   * Set the groundingModuleConfig of this {@link ModuleConfigs} instance and return the same
   * instance.
   *
   * @param groundingModuleConfig The groundingModuleConfig of this {@link ModuleConfigs}
   * @return The same instance of this {@link ModuleConfigs} class
   */
  @Nonnull
  public ModuleConfigs groundingModuleConfig(
      @Nullable final GroundingModuleConfig groundingModuleConfig) {
    this.groundingModuleConfig = groundingModuleConfig;
    return this;
  }

  /**
   * Get groundingModuleConfig
   *
   * @return groundingModuleConfig The groundingModuleConfig of this {@link ModuleConfigs} instance.
   */
  @Nonnull
  public GroundingModuleConfig getGroundingModuleConfig() {
    return groundingModuleConfig;
  }

  /**
   * Set the groundingModuleConfig of this {@link ModuleConfigs} instance.
   *
   * @param groundingModuleConfig The groundingModuleConfig of this {@link ModuleConfigs}
   */
  public void setGroundingModuleConfig(
      @Nullable final GroundingModuleConfig groundingModuleConfig) {
    this.groundingModuleConfig = groundingModuleConfig;
  }

  /**
   * Set the inputTranslationModuleConfig of this {@link ModuleConfigs} instance and return the same
   * instance.
   *
   * @param inputTranslationModuleConfig The inputTranslationModuleConfig of this {@link
   *     ModuleConfigs}
   * @return The same instance of this {@link ModuleConfigs} class
   */
  @Nonnull
  public ModuleConfigs inputTranslationModuleConfig(
      @Nullable final SAPDocumentTranslation inputTranslationModuleConfig) {
    this.inputTranslationModuleConfig = inputTranslationModuleConfig;
    return this;
  }

  /**
   * Get inputTranslationModuleConfig
   *
   * @return inputTranslationModuleConfig The inputTranslationModuleConfig of this {@link
   *     ModuleConfigs} instance.
   */
  @Nonnull
  public SAPDocumentTranslation getInputTranslationModuleConfig() {
    return inputTranslationModuleConfig;
  }

  /**
   * Set the inputTranslationModuleConfig of this {@link ModuleConfigs} instance.
   *
   * @param inputTranslationModuleConfig The inputTranslationModuleConfig of this {@link
   *     ModuleConfigs}
   */
  public void setInputTranslationModuleConfig(
      @Nullable final SAPDocumentTranslation inputTranslationModuleConfig) {
    this.inputTranslationModuleConfig = inputTranslationModuleConfig;
  }

  /**
   * Set the outputTranslationModuleConfig of this {@link ModuleConfigs} instance and return the
   * same instance.
   *
   * @param outputTranslationModuleConfig The outputTranslationModuleConfig of this {@link
   *     ModuleConfigs}
   * @return The same instance of this {@link ModuleConfigs} class
   */
  @Nonnull
  public ModuleConfigs outputTranslationModuleConfig(
      @Nullable final SAPDocumentTranslation outputTranslationModuleConfig) {
    this.outputTranslationModuleConfig = outputTranslationModuleConfig;
    return this;
  }

  /**
   * Get outputTranslationModuleConfig
   *
   * @return outputTranslationModuleConfig The outputTranslationModuleConfig of this {@link
   *     ModuleConfigs} instance.
   */
  @Nonnull
  public SAPDocumentTranslation getOutputTranslationModuleConfig() {
    return outputTranslationModuleConfig;
  }

  /**
   * Set the outputTranslationModuleConfig of this {@link ModuleConfigs} instance.
   *
   * @param outputTranslationModuleConfig The outputTranslationModuleConfig of this {@link
   *     ModuleConfigs}
   */
  public void setOutputTranslationModuleConfig(
      @Nullable final SAPDocumentTranslation outputTranslationModuleConfig) {
    this.outputTranslationModuleConfig = outputTranslationModuleConfig;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link ModuleConfigs}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link ModuleConfigs} instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException("ModuleConfigs has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link ModuleConfigs} instance including unrecognized
   * properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (llmModuleConfig != null) declaredFields.put("llmModuleConfig", llmModuleConfig);
    if (templatingModuleConfig != null)
      declaredFields.put("templatingModuleConfig", templatingModuleConfig);
    if (filteringModuleConfig != null)
      declaredFields.put("filteringModuleConfig", filteringModuleConfig);
    if (maskingModuleConfig != null) declaredFields.put("maskingModuleConfig", maskingModuleConfig);
    if (groundingModuleConfig != null)
      declaredFields.put("groundingModuleConfig", groundingModuleConfig);
    if (inputTranslationModuleConfig != null)
      declaredFields.put("inputTranslationModuleConfig", inputTranslationModuleConfig);
    if (outputTranslationModuleConfig != null)
      declaredFields.put("outputTranslationModuleConfig", outputTranslationModuleConfig);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link ModuleConfigs} instance. If the map previously
   * contained a mapping for the key, the old value is replaced by the specified value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final ModuleConfigs moduleConfigs = (ModuleConfigs) o;
    return Objects.equals(this.cloudSdkCustomFields, moduleConfigs.cloudSdkCustomFields)
        && Objects.equals(this.llmModuleConfig, moduleConfigs.llmModuleConfig)
        && Objects.equals(this.templatingModuleConfig, moduleConfigs.templatingModuleConfig)
        && Objects.equals(this.filteringModuleConfig, moduleConfigs.filteringModuleConfig)
        && Objects.equals(this.maskingModuleConfig, moduleConfigs.maskingModuleConfig)
        && Objects.equals(this.groundingModuleConfig, moduleConfigs.groundingModuleConfig)
        && Objects.equals(
            this.inputTranslationModuleConfig, moduleConfigs.inputTranslationModuleConfig)
        && Objects.equals(
            this.outputTranslationModuleConfig, moduleConfigs.outputTranslationModuleConfig);
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        llmModuleConfig,
        templatingModuleConfig,
        filteringModuleConfig,
        maskingModuleConfig,
        groundingModuleConfig,
        inputTranslationModuleConfig,
        outputTranslationModuleConfig,
        cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class ModuleConfigs {\n");
    sb.append("    llmModuleConfig: ").append(toIndentedString(llmModuleConfig)).append("\n");
    sb.append("    templatingModuleConfig: ")
        .append(toIndentedString(templatingModuleConfig))
        .append("\n");
    sb.append("    filteringModuleConfig: ")
        .append(toIndentedString(filteringModuleConfig))
        .append("\n");
    sb.append("    maskingModuleConfig: ")
        .append(toIndentedString(maskingModuleConfig))
        .append("\n");
    sb.append("    groundingModuleConfig: ")
        .append(toIndentedString(groundingModuleConfig))
        .append("\n");
    sb.append("    inputTranslationModuleConfig: ")
        .append(toIndentedString(inputTranslationModuleConfig))
        .append("\n");
    sb.append("    outputTranslationModuleConfig: ")
        .append(toIndentedString(outputTranslationModuleConfig))
        .append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create a type-safe, fluent-api builder object to construct a new {@link ModuleConfigs} instance
   * with all required arguments.
   */
  public static Builder create() {
    return (llmModuleConfig) ->
        (templatingModuleConfig) ->
            new ModuleConfigs()
                .llmModuleConfig(llmModuleConfig)
                .templatingModuleConfig(templatingModuleConfig);
  }

  /** Builder helper class. */
  public interface Builder {
    /**
     * Set the llmModuleConfig of this {@link ModuleConfigs} instance.
     *
     * @param llmModuleConfig The llmModuleConfig of this {@link ModuleConfigs}
     * @return The ModuleConfigs builder.
     */
    Builder1 llmModuleConfig(@Nonnull final LLMModuleConfig llmModuleConfig);
  }

  /** Builder helper class. */
  public interface Builder1 {
    /**
     * Set the templatingModuleConfig of this {@link ModuleConfigs} instance.
     *
     * @param templatingModuleConfig The templatingModuleConfig of this {@link ModuleConfigs}
     * @return The ModuleConfigs instance.
     */
    ModuleConfigs templatingModuleConfig(
        @Nonnull final TemplatingModuleConfig templatingModuleConfig);
  }
}
