/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/** Configuration for &#x60;sap_document_translation&#x60; translation provider. */
// CHECKSTYLE:OFF
public class SAPDocumentTranslationConfig
// CHECKSTYLE:ON
{
  @JsonProperty("source_language")
  private String sourceLanguage;

  @JsonProperty("target_language")
  private String targetLanguage;

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for SAPDocumentTranslationConfig. */
  protected SAPDocumentTranslationConfig() {}

  /**
   * Set the sourceLanguage of this {@link SAPDocumentTranslationConfig} instance and return the
   * same instance.
   *
   * @param sourceLanguage Language of the text to be translated.
   * @return The same instance of this {@link SAPDocumentTranslationConfig} class
   */
  @Nonnull
  public SAPDocumentTranslationConfig sourceLanguage(@Nullable final String sourceLanguage) {
    this.sourceLanguage = sourceLanguage;
    return this;
  }

  /**
   * Language of the text to be translated.
   *
   * @return sourceLanguage The sourceLanguage of this {@link SAPDocumentTranslationConfig}
   *     instance.
   */
  @Nonnull
  public String getSourceLanguage() {
    return sourceLanguage;
  }

  /**
   * Set the sourceLanguage of this {@link SAPDocumentTranslationConfig} instance.
   *
   * @param sourceLanguage Language of the text to be translated.
   */
  public void setSourceLanguage(@Nullable final String sourceLanguage) {
    this.sourceLanguage = sourceLanguage;
  }

  /**
   * Set the targetLanguage of this {@link SAPDocumentTranslationConfig} instance and return the
   * same instance.
   *
   * @param targetLanguage Language to which the text should be translated.
   * @return The same instance of this {@link SAPDocumentTranslationConfig} class
   */
  @Nonnull
  public SAPDocumentTranslationConfig targetLanguage(@Nonnull final String targetLanguage) {
    this.targetLanguage = targetLanguage;
    return this;
  }

  /**
   * Language to which the text should be translated.
   *
   * @return targetLanguage The targetLanguage of this {@link SAPDocumentTranslationConfig}
   *     instance.
   */
  @Nonnull
  public String getTargetLanguage() {
    return targetLanguage;
  }

  /**
   * Set the targetLanguage of this {@link SAPDocumentTranslationConfig} instance.
   *
   * @param targetLanguage Language to which the text should be translated.
   */
  public void setTargetLanguage(@Nonnull final String targetLanguage) {
    this.targetLanguage = targetLanguage;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link SAPDocumentTranslationConfig}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link SAPDocumentTranslationConfig}
   * instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException(
          "SAPDocumentTranslationConfig has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link SAPDocumentTranslationConfig} instance including
   * unrecognized properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (sourceLanguage != null) declaredFields.put("sourceLanguage", sourceLanguage);
    if (targetLanguage != null) declaredFields.put("targetLanguage", targetLanguage);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link SAPDocumentTranslationConfig} instance. If the
   * map previously contained a mapping for the key, the old value is replaced by the specified
   * value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final SAPDocumentTranslationConfig saPDocumentTranslationConfig =
        (SAPDocumentTranslationConfig) o;
    return Objects.equals(
            this.cloudSdkCustomFields, saPDocumentTranslationConfig.cloudSdkCustomFields)
        && Objects.equals(this.sourceLanguage, saPDocumentTranslationConfig.sourceLanguage)
        && Objects.equals(this.targetLanguage, saPDocumentTranslationConfig.targetLanguage);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sourceLanguage, targetLanguage, cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class SAPDocumentTranslationConfig {\n");
    sb.append("    sourceLanguage: ").append(toIndentedString(sourceLanguage)).append("\n");
    sb.append("    targetLanguage: ").append(toIndentedString(targetLanguage)).append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create a type-safe, fluent-api builder object to construct a new {@link
   * SAPDocumentTranslationConfig} instance with all required arguments.
   */
  public static Builder create() {
    return (targetLanguage) -> new SAPDocumentTranslationConfig().targetLanguage(targetLanguage);
  }

  /** Builder helper class. */
  public interface Builder {
    /**
     * Set the targetLanguage of this {@link SAPDocumentTranslationConfig} instance.
     *
     * @param targetLanguage Language to which the text should be translated.
     * @return The SAPDocumentTranslationConfig instance.
     */
    SAPDocumentTranslationConfig targetLanguage(@Nonnull final String targetLanguage);
  }
}
