/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/** Template */
// CHECKSTYLE:OFF
public class Template implements TemplatingModuleConfig
// CHECKSTYLE:ON
{
  @JsonProperty("template")
  private List<ChatMessage> template;

  @JsonProperty("defaults")
  private Map<String, String> defaults = new HashMap<>();

  @JsonProperty("response_format")
  private TemplateResponseFormat responseFormat;

  @JsonProperty("tools")
  private List<ChatCompletionTool> tools = new ArrayList<>();

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for Template. */
  protected Template() {}

  /**
   * Set the template of this {@link Template} instance and return the same instance.
   *
   * @param template A chat message array to be formatted with values from input_params. Both role
   *     and content can be templated. If messages_history is provided, the templated messages will
   *     be appended.
   * @return The same instance of this {@link Template} class
   */
  @Nonnull
  public Template template(@Nonnull final List<ChatMessage> template) {
    this.template = template;
    return this;
  }

  /**
   * Add one template instance to this {@link Template}.
   *
   * @param templateItem The template that should be added
   * @return The same instance of type {@link Template}
   */
  @Nonnull
  public Template addTemplateItem(@Nonnull final ChatMessage templateItem) {
    if (this.template == null) {
      this.template = new ArrayList<>();
    }
    this.template.add(templateItem);
    return this;
  }

  /**
   * A chat message array to be formatted with values from input_params. Both role and content can
   * be templated. If messages_history is provided, the templated messages will be appended.
   *
   * @return template The template of this {@link Template} instance.
   */
  @Nonnull
  public List<ChatMessage> getTemplate() {
    return template;
  }

  /**
   * Set the template of this {@link Template} instance.
   *
   * @param template A chat message array to be formatted with values from input_params. Both role
   *     and content can be templated. If messages_history is provided, the templated messages will
   *     be appended.
   */
  public void setTemplate(@Nonnull final List<ChatMessage> template) {
    this.template = template;
  }

  /**
   * Set the defaults of this {@link Template} instance and return the same instance.
   *
   * @param defaults Optional default values for the template. If a parameter has no default it is
   *     required.
   * @return The same instance of this {@link Template} class
   */
  @Nonnull
  public Template defaults(@Nullable final Map<String, String> defaults) {
    this.defaults = defaults;
    return this;
  }

  /**
   * Put one defaults instance to this {@link Template} instance.
   *
   * @param key The String key of this defaults instance
   * @param defaultsItem The defaults that should be added under the given key
   * @return The same instance of type {@link Template}
   */
  @Nonnull
  public Template putdefaultsItem(@Nonnull final String key, @Nonnull final String defaultsItem) {
    if (this.defaults == null) {
      this.defaults = new HashMap<>();
    }
    this.defaults.put(key, defaultsItem);
    return this;
  }

  /**
   * Optional default values for the template. If a parameter has no default it is required.
   *
   * @return defaults The defaults of this {@link Template} instance.
   */
  @Nonnull
  public Map<String, String> getDefaults() {
    return defaults;
  }

  /**
   * Set the defaults of this {@link Template} instance.
   *
   * @param defaults Optional default values for the template. If a parameter has no default it is
   *     required.
   */
  public void setDefaults(@Nullable final Map<String, String> defaults) {
    this.defaults = defaults;
  }

  /**
   * Set the responseFormat of this {@link Template} instance and return the same instance.
   *
   * @param responseFormat The responseFormat of this {@link Template}
   * @return The same instance of this {@link Template} class
   */
  @Nonnull
  public Template responseFormat(@Nullable final TemplateResponseFormat responseFormat) {
    this.responseFormat = responseFormat;
    return this;
  }

  /**
   * Get responseFormat
   *
   * @return responseFormat The responseFormat of this {@link Template} instance.
   */
  @Nonnull
  public TemplateResponseFormat getResponseFormat() {
    return responseFormat;
  }

  /**
   * Set the responseFormat of this {@link Template} instance.
   *
   * @param responseFormat The responseFormat of this {@link Template}
   */
  public void setResponseFormat(@Nullable final TemplateResponseFormat responseFormat) {
    this.responseFormat = responseFormat;
  }

  /**
   * Set the tools of this {@link Template} instance and return the same instance.
   *
   * @param tools A list of tools the model may call. Used to provide a list of functions the model
   *     may generate JSON inputs for. This is the same as the OpenAI definition.
   * @return The same instance of this {@link Template} class
   */
  @Nonnull
  public Template tools(@Nullable final List<ChatCompletionTool> tools) {
    this.tools = tools;
    return this;
  }

  /**
   * Add one tools instance to this {@link Template}.
   *
   * @param toolsItem The tools that should be added
   * @return The same instance of type {@link Template}
   */
  @Nonnull
  public Template addToolsItem(@Nonnull final ChatCompletionTool toolsItem) {
    if (this.tools == null) {
      this.tools = new ArrayList<>();
    }
    this.tools.add(toolsItem);
    return this;
  }

  /**
   * A list of tools the model may call. Used to provide a list of functions the model may generate
   * JSON inputs for. This is the same as the OpenAI definition.
   *
   * @return tools The tools of this {@link Template} instance.
   */
  @Nonnull
  public List<ChatCompletionTool> getTools() {
    return tools;
  }

  /**
   * Set the tools of this {@link Template} instance.
   *
   * @param tools A list of tools the model may call. Used to provide a list of functions the model
   *     may generate JSON inputs for. This is the same as the OpenAI definition.
   */
  public void setTools(@Nullable final List<ChatCompletionTool> tools) {
    this.tools = tools;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link Template}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link Template} instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException("Template has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link Template} instance including unrecognized
   * properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (template != null) declaredFields.put("template", template);
    if (defaults != null) declaredFields.put("defaults", defaults);
    if (responseFormat != null) declaredFields.put("responseFormat", responseFormat);
    if (tools != null) declaredFields.put("tools", tools);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link Template} instance. If the map previously
   * contained a mapping for the key, the old value is replaced by the specified value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final Template template = (Template) o;
    return Objects.equals(this.cloudSdkCustomFields, template.cloudSdkCustomFields)
        && Objects.equals(this.template, template.template)
        && Objects.equals(this.defaults, template.defaults)
        && Objects.equals(this.responseFormat, template.responseFormat)
        && Objects.equals(this.tools, template.tools);
  }

  @Override
  public int hashCode() {
    return Objects.hash(template, defaults, responseFormat, tools, cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class Template {\n");
    sb.append("    template: ").append(toIndentedString(template)).append("\n");
    sb.append("    defaults: ").append(toIndentedString(defaults)).append("\n");
    sb.append("    responseFormat: ").append(toIndentedString(responseFormat)).append("\n");
    sb.append("    tools: ").append(toIndentedString(tools)).append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create a type-safe, fluent-api builder object to construct a new {@link Template} instance with
   * all required arguments.
   */
  public static Builder create() {
    return (template) -> new Template().template(template);
  }

  /** Builder helper class. */
  public interface Builder {
    /**
     * Set the template of this {@link Template} instance.
     *
     * @param template A chat message array to be formatted with values from input_params. Both role
     *     and content can be templated. If messages_history is provided, the templated messages
     *     will be appended.
     * @return The Template instance.
     */
    Template template(@Nonnull final List<ChatMessage> template);

    /**
     * Set the template of this {@link Template} instance.
     *
     * @param template A chat message array to be formatted with values from input_params. Both role
     *     and content can be templated. If messages_history is provided, the templated messages
     *     will be appended.
     * @return The Template instance.
     */
    default Template template(@Nonnull final ChatMessage... template) {
      return template(Arrays.asList(template));
    }
  }
}
