/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/** ToolCallChunk */
// CHECKSTYLE:OFF
public class ToolCallChunk
// CHECKSTYLE:ON
{
  @JsonProperty("index")
  private Integer index;

  @JsonProperty("id")
  private String id;

  /** The type of the tool. Currently, only &#x60;function&#x60; is supported. */
  public enum TypeEnum {
    /** The FUNCTION option of this ToolCallChunk */
    FUNCTION("function"),

    /** The UNKNOWN_DEFAULT_OPEN_API option of this ToolCallChunk */
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    /**
     * Get the value of the enum
     *
     * @return The enum value
     */
    @JsonValue
    @Nonnull
    public String getValue() {
      return value;
    }

    /**
     * Get the String value of the enum value.
     *
     * @return The enum value as String
     */
    @Override
    @Nonnull
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * Get the enum value from a String value
     *
     * @param value The String value
     * @return The enum value of type ToolCallChunk
     */
    @JsonCreator
    @Nonnull
    public static TypeEnum fromValue(@Nonnull final String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  @JsonProperty("type")
  private TypeEnum type;

  @JsonProperty("function")
  private ToolCallChunkFunction function;

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for ToolCallChunk. */
  protected ToolCallChunk() {}

  /**
   * Set the index of this {@link ToolCallChunk} instance and return the same instance.
   *
   * @param index The index of this {@link ToolCallChunk}
   * @return The same instance of this {@link ToolCallChunk} class
   */
  @Nonnull
  public ToolCallChunk index(@Nonnull final Integer index) {
    this.index = index;
    return this;
  }

  /**
   * Get index
   *
   * @return index The index of this {@link ToolCallChunk} instance.
   */
  @Nonnull
  public Integer getIndex() {
    return index;
  }

  /**
   * Set the index of this {@link ToolCallChunk} instance.
   *
   * @param index The index of this {@link ToolCallChunk}
   */
  public void setIndex(@Nonnull final Integer index) {
    this.index = index;
  }

  /**
   * Set the id of this {@link ToolCallChunk} instance and return the same instance.
   *
   * @param id The ID of the tool call.
   * @return The same instance of this {@link ToolCallChunk} class
   */
  @Nonnull
  public ToolCallChunk id(@Nullable final String id) {
    this.id = id;
    return this;
  }

  /**
   * The ID of the tool call.
   *
   * @return id The id of this {@link ToolCallChunk} instance.
   */
  @Nonnull
  public String getId() {
    return id;
  }

  /**
   * Set the id of this {@link ToolCallChunk} instance.
   *
   * @param id The ID of the tool call.
   */
  public void setId(@Nullable final String id) {
    this.id = id;
  }

  /**
   * Set the type of this {@link ToolCallChunk} instance and return the same instance.
   *
   * @param type The type of the tool. Currently, only &#x60;function&#x60; is supported.
   * @return The same instance of this {@link ToolCallChunk} class
   */
  @Nonnull
  public ToolCallChunk type(@Nullable final TypeEnum type) {
    this.type = type;
    return this;
  }

  /**
   * The type of the tool. Currently, only &#x60;function&#x60; is supported.
   *
   * @return type The type of this {@link ToolCallChunk} instance.
   */
  @Nonnull
  public TypeEnum getType() {
    return type;
  }

  /**
   * Set the type of this {@link ToolCallChunk} instance.
   *
   * @param type The type of the tool. Currently, only &#x60;function&#x60; is supported.
   */
  public void setType(@Nullable final TypeEnum type) {
    this.type = type;
  }

  /**
   * Set the function of this {@link ToolCallChunk} instance and return the same instance.
   *
   * @param function The function of this {@link ToolCallChunk}
   * @return The same instance of this {@link ToolCallChunk} class
   */
  @Nonnull
  public ToolCallChunk function(@Nullable final ToolCallChunkFunction function) {
    this.function = function;
    return this;
  }

  /**
   * Get function
   *
   * @return function The function of this {@link ToolCallChunk} instance.
   */
  @Nonnull
  public ToolCallChunkFunction getFunction() {
    return function;
  }

  /**
   * Set the function of this {@link ToolCallChunk} instance.
   *
   * @param function The function of this {@link ToolCallChunk}
   */
  public void setFunction(@Nullable final ToolCallChunkFunction function) {
    this.function = function;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link ToolCallChunk}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link ToolCallChunk} instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException("ToolCallChunk has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link ToolCallChunk} instance including unrecognized
   * properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (index != null) declaredFields.put("index", index);
    if (id != null) declaredFields.put("id", id);
    if (type != null) declaredFields.put("type", type);
    if (function != null) declaredFields.put("function", function);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link ToolCallChunk} instance. If the map previously
   * contained a mapping for the key, the old value is replaced by the specified value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final ToolCallChunk toolCallChunk = (ToolCallChunk) o;
    return Objects.equals(this.cloudSdkCustomFields, toolCallChunk.cloudSdkCustomFields)
        && Objects.equals(this.index, toolCallChunk.index)
        && Objects.equals(this.id, toolCallChunk.id)
        && Objects.equals(this.type, toolCallChunk.type)
        && Objects.equals(this.function, toolCallChunk.function);
  }

  @Override
  public int hashCode() {
    return Objects.hash(index, id, type, function, cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class ToolCallChunk {\n");
    sb.append("    index: ").append(toIndentedString(index)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    function: ").append(toIndentedString(function)).append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create a type-safe, fluent-api builder object to construct a new {@link ToolCallChunk} instance
   * with all required arguments.
   */
  public static Builder create() {
    return (index) -> new ToolCallChunk().index(index);
  }

  /** Builder helper class. */
  public interface Builder {
    /**
     * Set the index of this {@link ToolCallChunk} instance.
     *
     * @param index The index of this {@link ToolCallChunk}
     * @return The ToolCallChunk instance.
     */
    ToolCallChunk index(@Nonnull final Integer index);
  }
}
