/*
 * Internal Orchestration Service API
 * Orchestration is an inference service which provides common additional capabilities for business AI scenarios, such as content filtering and data masking. At the core of the service is the LLM module which allows for an easy, harmonized access to the language models of gen AI hub. The service is designed to be modular and extensible, allowing for the addition of new modules in the future. Each module can be configured independently and at runtime, allowing for a high degree of flexibility in the orchestration of AI services.
 *
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

package com.sap.ai.sdk.orchestration.model;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

/** UserChatMessage */
// CHECKSTYLE:OFF
public class UserChatMessage implements ChatMessage
// CHECKSTYLE:ON
{
  @JsonProperty("content")
  private UserChatMessageContent content;

  /** Gets or Sets role */
  public enum RoleEnum {
    /** The USER option of this UserChatMessage */
    USER("user"),

    /** The UNKNOWN_DEFAULT_OPEN_API option of this UserChatMessage */
    UNKNOWN_DEFAULT_OPEN_API("unknown_default_open_api");

    private String value;

    RoleEnum(String value) {
      this.value = value;
    }

    /**
     * Get the value of the enum
     *
     * @return The enum value
     */
    @JsonValue
    @Nonnull
    public String getValue() {
      return value;
    }

    /**
     * Get the String value of the enum value.
     *
     * @return The enum value as String
     */
    @Override
    @Nonnull
    public String toString() {
      return String.valueOf(value);
    }

    /**
     * Get the enum value from a String value
     *
     * @param value The String value
     * @return The enum value of type UserChatMessage
     */
    @JsonCreator
    @Nonnull
    public static RoleEnum fromValue(@Nonnull final String value) {
      for (RoleEnum b : RoleEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return UNKNOWN_DEFAULT_OPEN_API;
    }
  }

  @JsonProperty("role")
  private RoleEnum role;

  @JsonAnySetter @JsonAnyGetter
  private final Map<String, Object> cloudSdkCustomFields = new LinkedHashMap<>();

  /** Default constructor for UserChatMessage. */
  protected UserChatMessage() {}

  /**
   * Set the content of this {@link UserChatMessage} instance and return the same instance.
   *
   * @param content The content of this {@link UserChatMessage}
   * @return The same instance of this {@link UserChatMessage} class
   */
  @Nonnull
  public UserChatMessage content(@Nonnull final UserChatMessageContent content) {
    this.content = content;
    return this;
  }

  /**
   * Get content
   *
   * @return content The content of this {@link UserChatMessage} instance.
   */
  @Nonnull
  public UserChatMessageContent getContent() {
    return content;
  }

  /**
   * Set the content of this {@link UserChatMessage} instance.
   *
   * @param content The content of this {@link UserChatMessage}
   */
  public void setContent(@Nonnull final UserChatMessageContent content) {
    this.content = content;
  }

  /**
   * Set the role of this {@link UserChatMessage} instance and return the same instance.
   *
   * @param role The role of this {@link UserChatMessage}
   * @return The same instance of this {@link UserChatMessage} class
   */
  @Nonnull
  public UserChatMessage role(@Nonnull final RoleEnum role) {
    this.role = role;
    return this;
  }

  /**
   * Get role
   *
   * @return role The role of this {@link UserChatMessage} instance.
   */
  @Nonnull
  public RoleEnum getRole() {
    return role;
  }

  /**
   * Set the role of this {@link UserChatMessage} instance.
   *
   * @param role The role of this {@link UserChatMessage}
   */
  public void setRole(@Nonnull final RoleEnum role) {
    this.role = role;
  }

  /**
   * Get the names of the unrecognizable properties of the {@link UserChatMessage}.
   *
   * @return The set of properties names
   */
  @JsonIgnore
  @Nonnull
  public Set<String> getCustomFieldNames() {
    return cloudSdkCustomFields.keySet();
  }

  /**
   * Get the value of an unrecognizable property of this {@link UserChatMessage} instance.
   *
   * @deprecated Use {@link #toMap()} instead.
   * @param name The name of the property
   * @return The value of the property
   * @throws NoSuchElementException If no property with the given name could be found.
   */
  @Nullable
  @Deprecated
  public Object getCustomField(@Nonnull final String name) throws NoSuchElementException {
    if (!cloudSdkCustomFields.containsKey(name)) {
      throw new NoSuchElementException("UserChatMessage has no field with name '" + name + "'.");
    }
    return cloudSdkCustomFields.get(name);
  }

  /**
   * Get the value of all properties of this {@link UserChatMessage} instance including unrecognized
   * properties.
   *
   * @return The map of all properties
   */
  @JsonIgnore
  @Nonnull
  public Map<String, Object> toMap() {
    final Map<String, Object> declaredFields = new LinkedHashMap<>(cloudSdkCustomFields);
    if (content != null) declaredFields.put("content", content);
    if (role != null) declaredFields.put("role", role);
    return declaredFields;
  }

  /**
   * Set an unrecognizable property of this {@link UserChatMessage} instance. If the map previously
   * contained a mapping for the key, the old value is replaced by the specified value.
   *
   * @param customFieldName The name of the property
   * @param customFieldValue The value of the property
   */
  @JsonIgnore
  public void setCustomField(@Nonnull String customFieldName, @Nullable Object customFieldValue) {
    cloudSdkCustomFields.put(customFieldName, customFieldValue);
  }

  @Override
  public boolean equals(@Nullable final java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    final UserChatMessage userChatMessage = (UserChatMessage) o;
    return Objects.equals(this.cloudSdkCustomFields, userChatMessage.cloudSdkCustomFields)
        && Objects.equals(this.content, userChatMessage.content)
        && Objects.equals(this.role, userChatMessage.role);
  }

  @Override
  public int hashCode() {
    return Objects.hash(content, role, cloudSdkCustomFields);
  }

  @Override
  @Nonnull
  public String toString() {
    final StringBuilder sb = new StringBuilder();
    sb.append("class UserChatMessage {\n");
    sb.append("    content: ").append(toIndentedString(content)).append("\n");
    sb.append("    role: ").append(toIndentedString(role)).append("\n");
    cloudSdkCustomFields.forEach(
        (k, v) ->
            sb.append("    ").append(k).append(": ").append(toIndentedString(v)).append("\n"));
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces (except the first line).
   */
  private String toIndentedString(final java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

  /**
   * Create a type-safe, fluent-api builder object to construct a new {@link UserChatMessage}
   * instance with all required arguments.
   */
  public static Builder create() {
    return (content) -> (role) -> new UserChatMessage().content(content).role(role);
  }

  /** Builder helper class. */
  public interface Builder {
    /**
     * Set the content of this {@link UserChatMessage} instance.
     *
     * @param content The content of this {@link UserChatMessage}
     * @return The UserChatMessage builder.
     */
    Builder1 content(@Nonnull final UserChatMessageContent content);
  }

  /** Builder helper class. */
  public interface Builder1 {
    /**
     * Set the role of this {@link UserChatMessage} instance.
     *
     * @param role The role of this {@link UserChatMessage}
     * @return The UserChatMessage instance.
     */
    UserChatMessage role(@Nonnull final RoleEnum role);
  }
}
